/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.FileType;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.JavaSquid;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.CheckList;
import org.sonar.plugins.java.Bridges;
import org.sonar.plugins.java.DefaultJavaResourceLocator;
import org.sonar.squid.api.CodeVisitor;

@Phase(name=Phase.Name.PRE)
@DependsUpon(value={"BEFORE_SQUID"})
@DependedUpon(value={"squid"})
public class JavaSquidSensor
implements Sensor {
    private final AnnotationCheckFactory annotationCheckFactory;
    private final NoSonarFilter noSonarFilter;
    private final ProjectClasspath projectClasspath;
    private final SonarComponents sonarComponents;
    private final ModuleFileSystem moduleFileSystem;
    private final DefaultJavaResourceLocator javaResourceLocator;
    private final RulesProfile profile;
    private Settings settings;

    public JavaSquidSensor(RulesProfile profile, NoSonarFilter noSonarFilter, ProjectClasspath projectClasspath, SonarComponents sonarComponents, ModuleFileSystem moduleFileSystem, DefaultJavaResourceLocator javaResourceLocator, Settings settings) {
        this.profile = profile;
        this.annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"squid", (Collection)CheckList.getChecks());
        this.noSonarFilter = noSonarFilter;
        this.projectClasspath = projectClasspath;
        this.sonarComponents = sonarComponents;
        this.moduleFileSystem = moduleFileSystem;
        this.javaResourceLocator = javaResourceLocator;
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.moduleFileSystem.files(FileQuery.on((FileType[])FileType.values()).onLanguage(new String[]{"java"})).isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        Collection checks = this.annotationCheckFactory.getChecks();
        JavaSquid squid = new JavaSquid(this.createConfiguration(project), this.sonarComponents, checks.toArray(new CodeVisitor[checks.size()]));
        squid.scan(this.getSourceFiles(project), this.getTestFiles(project), this.getBytecodeFiles(project));
        this.javaResourceLocator.setSquidIndex(squid.getIndex());
        new Bridges(squid, this.settings).save(context, project, (CheckFactory)this.annotationCheckFactory, this.noSonarFilter, this.profile);
    }

    private List<InputFile> getSourceFiles(Project project) {
        return project.getFileSystem().mainFiles(new String[]{"java"});
    }

    private List<InputFile> getTestFiles(Project project) {
        return project.getFileSystem().testFiles(new String[]{"java"});
    }

    private List<File> getBytecodeFiles(Project project) {
        if (this.settings.getBoolean("sonar.skipDesign")) {
            return Collections.emptyList();
        }
        return this.projectClasspath.getElements();
    }

    private JavaConfiguration createConfiguration(Project project) {
        boolean analyzePropertyAccessors = this.settings.getBoolean("sonar.squid.analyse.property.accessors");
        Charset charset = this.moduleFileSystem.sourceCharset();
        JavaConfiguration conf = new JavaConfiguration(charset);
        conf.setAnalyzePropertyAccessors(analyzePropertyAccessors);
        return conf;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

