/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="CurlyBraces", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AlwaysUseCurlyBracesCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).ifStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).forInStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).forStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).whileStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).doWhileStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).elseClause});
    }

    public void visitNode(AstNode astNode) {
        List statements = astNode.findDirectChildren(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statement});
        for (AstNode statement : statements) {
            if (statement.getChild(0).is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).ifStatement}) && statement.previousSibling().is(new AstNodeType[]{EcmaScriptKeyword.ELSE}) || statement.getChild(0).is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).block})) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Missing curly brace.", astNode, new Object[0]);
            break;
        }
    }
}

