/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="AssignmentWithinCondition", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AssignmentWithinConditionCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).ifStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).doWhileStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).whileStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).forStatement});
    }

    public void visitNode(AstNode astNode) {
        AstNode conditionNode = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).condition});
        if (conditionNode != null && conditionNode.getChild(0).findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).assignmentExpression}) != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this assignment from the expression.", conditionNode, new Object[0]);
        }
    }
}

