/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="CollapsibleIfStatements", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CollapsibleIfStatementsCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).ifStatement});
    }

    public void visitNode(AstNode node) {
        AstNode innerStatement;
        if (this.isIfStatementWithoutElse(node) && (this.isBlockAndContainsOnlyOneIfStatement(innerStatement = node.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statement}).getFirstChild()) || this.isIfStatementWithoutElse(innerStatement))) {
            this.getContext().createLineViolation((CodeCheck)this, "Those two 'if' statements can be consolidated.", node, new Object[0]);
        }
    }

    private boolean isBlockAndContainsOnlyOneIfStatement(AstNode statement) {
        if (!statement.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).block})) {
            return false;
        }
        AstNode statementList = statement.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statementList});
        if (statementList == null || statementList.getNumberOfChildren() != 1 || statementList.getFirstChild().isNot(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statement})) {
            return false;
        }
        return this.isIfStatementWithoutElse(statementList.getFirstChild().getFirstChild());
    }

    private boolean isIfStatementWithoutElse(AstNode statement) {
        return !statement.isNot(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).ifStatement}) && !statement.hasDirectChildren(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).elseClause});
    }
}

