/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="OctalNumber", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class OctalNumberCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).numericLiteral});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (value.length() > 1 && value.startsWith("0")) {
            int newValue;
            try {
                newValue = Integer.parseInt(value, 8);
            }
            catch (NumberFormatException e) {
                return;
            }
            this.getContext().createLineViolation((CodeCheck)this, "Replace the value of the octal number (" + value + ") by its decimal equivalent (" + newValue + ").", astNode, new Object[0]);
        }
    }
}

