/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="Parentheses", priority=Priority.MINOR)
public class ParenthesesCheck
extends SquidCheck<EcmaScriptGrammar> {
    private static final Set<String> NO_PARENTHESES_AFTER = ImmutableSet.of((Object[])new String[]{"delete", "typeof", "void", "return", "throw", "new", "in"});

    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).unaryExpression, ((EcmaScriptGrammar)this.getContext().getGrammar()).expression, ((EcmaScriptGrammar)this.getContext().getGrammar()).newExpression});
    }

    public void visitNode(AstNode node) {
        if ("(".equals(node.getTokenValue()) && node.previousSibling() != null && NO_PARENTHESES_AFTER.contains(node.previousSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Those parentheses are useless.", node, new Object[0]);
        }
    }
}

