/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="PrimitiveWrappers", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class PrimitiveWrappersCheck
extends SquidCheck<EcmaScriptGrammar> {
    private static final Set<String> WRAPPERS = ImmutableSet.of((Object)"Boolean", (Object)"Number", (Object)"String");

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptKeyword.NEW});
    }

    public void visitNode(AstNode astNode) {
        if (WRAPPERS.contains(astNode.nextSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Do not use wrapper objects for primitive types.", astNode, new Object[0]);
        }
    }
}

