/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="TrailingComma", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class TrailingCommaCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).arrayLiteral, ((EcmaScriptGrammar)this.getContext().getGrammar()).objectLiteral});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getLastChild().previousSibling().getLastToken().getType() == EcmaScriptPunctuator.COMMA) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid trailing comma in array and object literals.", astNode, new Object[0]);
        }
    }
}

