/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="DuplicatePropertyName", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicatePropertyNameCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.OBJECT_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        HashSet values = Sets.newHashSet();
        List propertyAssignments = astNode.getChildren(new AstNodeType[]{EcmaScriptGrammar.PROPERTY_DEFINITION});
        for (AstNode propertyAssignment : propertyAssignments) {
            String unescaped;
            if (!propertyAssignment.getFirstChild().isNot(new AstNodeType[]{EcmaScriptGrammar.METHOD_DEFINITION})) continue;
            AstNode propertyName = DuplicatePropertyNameCheck.getPropertyName(propertyAssignment);
            String value = propertyName.getTokenValue();
            if (value.startsWith("\"") || value.startsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if (values.contains(unescaped = EscapeUtils.unescape(value))) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename or remove duplicate property name '" + value + "'.", propertyName, new Object[0]);
                continue;
            }
            values.add(unescaped);
        }
    }

    private static AstNode getPropertyName(AstNode propertyAssignment) {
        AstNode objectProperty = propertyAssignment.getFirstChild();
        if (objectProperty.is(new AstNodeType[]{EcmaScriptGrammar.PAIR_PROPERTY})) {
            return objectProperty.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.PROPERTY_NAME});
        }
        return objectProperty.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.IDENTIFIER_REFERENCE});
    }
}

