/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="StrictMode", priority=Priority.INFO)
@BelongsToProfile(title="Sonar way", priority=Priority.INFO)
public class StrictModeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if ("\"use strict\"".equals(value) || "'use strict'".equals(value)) {
            this.getContext().createLineViolation((CodeCheck)this, "Use of JavaScript strict mode may result in unexpected behaviour in some browsers.", astNode, new Object[0]);
        }
    }
}

