/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="AssignmentWithinCondition", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AssignmentWithinConditionCheck
extends SquidCheck<LexerlessGrammar> {
    private List<AstNodeType> stack;
    private static final AstNodeType[] SCOPES = new AstNodeType[]{EcmaScriptGrammar.CONDITION, EcmaScriptGrammar.FUNCTION_BODY, EcmaScriptGrammar.RELATIONAL_EXPRESSION, EcmaScriptGrammar.RELATIONAL_EXPRESSION_NO_IN, EcmaScriptGrammar.EQUALITY_EXPRESSION, EcmaScriptGrammar.EQUALITY_EXPRESSION_NO_IN};

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.ASSIGNMENT_EXPRESSION, EcmaScriptGrammar.EXPRESSION, EcmaScriptGrammar.EXPRESSION_NO_IN});
        this.subscribeTo(SCOPES);
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.stack = Lists.newArrayList();
    }

    public void visitNode(AstNode astNode) {
        if (this.isTargetedExpression(astNode) || astNode.is(SCOPES)) {
            this.stack.add(astNode.getType());
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.ASSIGNMENT_EXPRESSION}) && this.inExpression() && !this.exclusion()) {
            this.getContext().createLineViolation((CodeCheck)this, "Extract the assignment out of this expression.", astNode, new Object[0]);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (this.isTargetedExpression(astNode) || astNode.is(SCOPES)) {
            this.pop();
        }
    }

    private boolean inExpression() {
        AstNodeType t = this.peek(0);
        return EcmaScriptGrammar.EXPRESSION.equals((Object)t) || EcmaScriptGrammar.EXPRESSION_NO_IN.equals((Object)t) || EcmaScriptGrammar.CONDITION.equals((Object)t);
    }

    private boolean exclusion() {
        AstNodeType t = this.peek(1);
        return this.peek(2) == EcmaScriptGrammar.CONDITION && this.isExcludedExpression(t);
    }

    private boolean isExcludedExpression(AstNodeType node) {
        return EcmaScriptGrammar.EQUALITY_EXPRESSION.equals((Object)node) || EcmaScriptGrammar.EQUALITY_EXPRESSION_NO_IN.equals((Object)node) || EcmaScriptGrammar.RELATIONAL_EXPRESSION.equals((Object)node) || EcmaScriptGrammar.RELATIONAL_EXPRESSION_NO_IN.equals((Object)node);
    }

    private boolean isTargetedExpression(AstNode astNode) {
        return astNode.is(new AstNodeType[]{EcmaScriptGrammar.EXPRESSION, EcmaScriptGrammar.EXPRESSION_NO_IN}) && astNode.getParent().isNot(new AstNodeType[]{EcmaScriptGrammar.EXPRESSION_STATEMENT, EcmaScriptGrammar.CONDITION, EcmaScriptGrammar.FOR_STATEMENT});
    }

    private void pop() {
        this.stack.remove(this.stack.size() - 1);
    }

    @Nullable
    private AstNodeType peek(int i) {
        if (i < this.stack.size()) {
            return this.stack.get(this.stack.size() - 1 - i);
        }
        return null;
    }
}

