/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1125", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class BooleanEqualityComparisonCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.UNARY_EXPRESSION, EcmaScriptGrammar.EQUALITY_EXPRESSION, EcmaScriptGrammar.LOGICAL_AND_EXPRESSION, EcmaScriptGrammar.LOGICAL_OR_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        AstNode boolLiteral = BooleanEqualityComparisonCheck.getBooleanLiteralFromExpresion(astNode);
        if (boolLiteral != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the literal \"" + boolLiteral.getTokenOriginalValue() + "\" boolean value.", astNode, new Object[0]);
        }
    }

    private static AstNode getBooleanLiteralFromExpresion(AstNode expression) {
        if (expression.is(new AstNodeType[]{EcmaScriptGrammar.UNARY_EXPRESSION})) {
            return BooleanEqualityComparisonCheck.getBooleanLiteralFromUnaryExpression(expression);
        }
        if (expression.getNumberOfChildren() != 3) {
            return null;
        }
        AstNode leftExpr = expression.getFirstChild();
        AstNode rightExpr = expression.getLastChild();
        if (BooleanEqualityComparisonCheck.isBooleanLiteral(leftExpr)) {
            return leftExpr;
        }
        if (BooleanEqualityComparisonCheck.isBooleanLiteral(rightExpr)) {
            return rightExpr;
        }
        return null;
    }

    private static AstNode getBooleanLiteralFromUnaryExpression(AstNode unaryExpression) {
        AstNode expr;
        AstNode boolLiteral = null;
        if (unaryExpression.getFirstChild().is(new AstNodeType[]{EcmaScriptPunctuator.BANG}) && BooleanEqualityComparisonCheck.isBooleanLiteral(expr = unaryExpression.getLastChild())) {
            boolLiteral = expr;
        }
        return boolLiteral;
    }

    public static boolean isBooleanLiteral(AstNode node) {
        return EcmaScriptKeyword.FALSE.getValue().equals(node.getTokenValue()) || EcmaScriptKeyword.TRUE.getValue().equals(node.getTokenValue());
    }
}

