/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.checks.utils.IdentifierUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="BoundOrAssignedEvalOrArguments", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class BoundOrAssignedEvalOrArgumentsCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.GENERATOR_DECLARATION, EcmaScriptGrammar.GENERATOR_EXPRESSION};
    private static final GrammarRuleKey[] CONST_AND_VAR_NODES = new GrammarRuleKey[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.LEXICAL_BINDING, EcmaScriptGrammar.LEXICAL_BINDING_NO_IN};

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CATCH, EcmaScriptGrammar.PROPERTY_SET_PARAMETER_LIST, EcmaScriptGrammar.ASSIGNMENT_EXPRESSION, EcmaScriptGrammar.POSTFIX_EXPRESSION, EcmaScriptGrammar.UNARY_EXPRESSION});
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
        this.subscribeTo((AstNodeType[])CONST_AND_VAR_NODES);
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.checkFunction(astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.CATCH}) || astNode.is((AstNodeType[])CONST_AND_VAR_NODES)) {
            this.checkVariableDeclaration(astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.PROPERTY_SET_PARAMETER_LIST})) {
            this.checkPropertySetParameterList(astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.ASSIGNMENT_EXPRESSION})) {
            this.checkModification(astNode.getFirstDescendant(new AstNodeType[]{EcmaScriptGrammar.MEMBER_EXPRESSION}));
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.UNARY_EXPRESSION, EcmaScriptGrammar.POSTFIX_EXPRESSION}) && astNode.hasDirectChildren(new AstNodeType[]{EcmaScriptPunctuator.INC, EcmaScriptPunctuator.DEC})) {
            this.checkModification(astNode.getFirstDescendant(new AstNodeType[]{EcmaScriptGrammar.MEMBER_EXPRESSION}));
        }
    }

    private void checkFunction(AstNode functionNode) {
        AstNode formalParameterList;
        AstNode identifier = functionNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
        if (identifier != null && this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("function", identifier.getTokenValue()), identifier, new Object[0]);
        }
        if ((formalParameterList = functionNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) != null) {
            this.checkFormalParamList(formalParameterList);
        }
    }

    private void checkFormalParamList(AstNode formalParameterList) {
        for (AstNode identifier : IdentifierUtils.getParametersIdentifier(formalParameterList)) {
            String identifierName = identifier.getTokenValue();
            if (!this.isEvalOrArguments(identifierName)) continue;
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("parameter", identifierName), identifier, new Object[0]);
        }
    }

    private void checkVariableDeclaration(AstNode astNode) {
        List<AstNode> identifiers = astNode.is(new AstNodeType[]{EcmaScriptGrammar.CATCH}) ? IdentifierUtils.getCatchIdentifiers(astNode) : IdentifierUtils.getVariableIdentifiers(astNode);
        for (AstNode identifier : identifiers) {
            String identifierName = identifier.getTokenValue();
            if (!this.isEvalOrArguments(identifierName)) continue;
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("variable", identifierName), identifier, new Object[0]);
        }
    }

    private void checkPropertySetParameterList(AstNode propertySetParameterList) {
        for (AstNode identifier : IdentifierUtils.getParametersIdentifier(propertySetParameterList)) {
            String identifierName = identifier.getTokenValue();
            if (!this.isEvalOrArguments(identifierName)) continue;
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("parameter", identifierName), identifier, new Object[0]);
        }
    }

    private void checkModification(AstNode astNode) {
        if (this.isEvalOrArguments(astNode.getTokenValue()) && !astNode.hasDirectChildren(new AstNodeType[]{EcmaScriptGrammar.BRACKET_EXPRESSION}) && !astNode.getParent().is(new AstNodeType[]{EcmaScriptGrammar.SIMPLE_CALL_EXPRESSION})) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the modification of \"" + astNode.getTokenValue() + "\".", astNode, new Object[0]);
        }
    }

    private static String createMessageFor(String name, String value) {
        return "Do not use \"" + value + "\" to declare a " + name + " - use another name.";
    }

    private boolean isEvalOrArguments(String name) {
        return "eval".equals(name) || "arguments".equals(name);
    }
}

