/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="EmptyBlock", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class EmptyBlockCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.BLOCK});
    }

    public void visitNode(AstNode astNode) {
        if (!astNode.hasDirectChildren(new AstNodeType[]{EcmaScriptGrammar.STATEMENT_LIST}) && !EmptyBlockCheck.hasComment(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Either remove or fill this block of code.", astNode, new Object[0]);
        }
    }

    private static boolean hasComment(AstNode blockNode) {
        return blockNode.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE}).getToken().hasTrivia();
    }
}

