/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.checks.utils.FunctionUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RedeclaredFunction", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RedeclaredFunctionCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> stack;

    public void init() {
        this.subscribeTo((AstNodeType[])FunctionUtils.getFunctionNodes());
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            Set<String> currentScope = this.stack.peek();
            String functionName = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}).getTokenValue();
            if (currentScope.contains(functionName)) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename function \"" + functionName + "\" as this name is already used.", astNode, new Object[0]);
            } else {
                currentScope.add(functionName);
            }
        }
        this.stack.add(new HashSet());
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FunctionUtils.getFunctionNodes())) {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }
}

