/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.FunctionUtils;
import org.sonar.javascript.checks.utils.IdentifierUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RedeclaredVariable", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RedeclaredVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> stack;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN});
        this.subscribeTo((AstNodeType[])FunctionUtils.getFunctionNodes());
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FunctionUtils.getFunctionNodes())) {
            HashSet<String> currentScope = new HashSet<String>();
            this.stack.add(currentScope);
            this.addParametersToScope(astNode, currentScope);
        } else {
            String variableName;
            Set<String> currentScope = this.stack.peek();
            if (currentScope.contains(variableName = astNode.getTokenValue())) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename variable \"" + variableName + "\" as this name is already used.", astNode, new Object[0]);
            } else {
                currentScope.add(variableName);
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FunctionUtils.getFunctionNodes())) {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }

    private void addParametersToScope(AstNode functionNode, Set<String> currentScope) {
        if (functionNode.is(new AstNodeType[]{EcmaScriptGrammar.ARROW_FUNCTION})) {
            this.addArrowParametersToScope(functionNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.ARROW_PARAMETERS}), currentScope);
        } else {
            this.addFormalParametersToScope(functionNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST}), currentScope);
        }
    }

    private void addArrowParametersToScope(AstNode arrowParameters, Set<String> currentScope) {
        if (arrowParameters != null) {
            for (AstNode parameter : IdentifierUtils.getArrowParametersIdentifier(arrowParameters)) {
                currentScope.add(parameter.getTokenValue());
            }
        }
    }

    private void addFormalParametersToScope(AstNode formalParameterList, Set<String> currentScope) {
        if (formalParameterList != null) {
            for (AstNode identifier : IdentifierUtils.getParametersIdentifier(formalParameterList)) {
                currentScope.add(identifier.getTokenValue());
            }
        }
    }
}

