/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.checks.utils.FunctionUtils;
import org.sonar.javascript.checks.utils.IdentifierUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="VariableDeclarationAfterUsage", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class VariableDeclarationAfterUsageCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] CONST_AND_VAR_NODES = new GrammarRuleKey[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.LEXICAL_BINDING, EcmaScriptGrammar.LEXICAL_BINDING_NO_IN};
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.PRIMARY_EXPRESSION, EcmaScriptGrammar.FORMAL_PARAMETER_LIST, EcmaScriptGrammar.ARROW_PARAMETERS});
        this.subscribeTo((AstNodeType[])CONST_AND_VAR_NODES);
        this.subscribeTo((AstNodeType[])FunctionUtils.getFunctionNodes());
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = new Scope();
    }

    public void visitNode(AstNode astNode) {
        AstNode identifier;
        if (astNode.is((AstNodeType[])FunctionUtils.getFunctionNodes())) {
            this.currentScope = new Scope(this.currentScope);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) {
            this.declareInCurrentScope(IdentifierUtils.getParametersIdentifier(astNode));
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.ARROW_PARAMETERS})) {
            this.declareInCurrentScope(IdentifierUtils.getArrowParametersIdentifier(astNode));
        } else if (astNode.is((AstNodeType[])CONST_AND_VAR_NODES)) {
            this.declareInCurrentScope(IdentifierUtils.getVariableIdentifiers(astNode));
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.PRIMARY_EXPRESSION}) && (identifier = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) != null) {
            this.currentScope.use(identifier);
        }
    }

    private void declareInCurrentScope(List<AstNode> identifiers) {
        for (AstNode identifier : identifiers) {
            this.currentScope.declare(identifier);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FunctionUtils.getFunctionNodes())) {
            this.checkCurrentScope();
            for (Map.Entry<String, AstNode> entry : this.currentScope.firstUsage.entrySet()) {
                if (this.currentScope.firstDeclaration.containsKey(entry.getKey())) continue;
                this.currentScope.outerScope.use(entry.getValue());
            }
            this.currentScope = this.currentScope.outerScope;
        }
    }

    private void checkCurrentScope() {
        for (Map.Entry<String, AstNode> entry : this.currentScope.firstDeclaration.entrySet()) {
            AstNode declaration = entry.getValue();
            AstNode usage = this.currentScope.firstUsage.get(entry.getKey());
            if (usage == null || usage.getTokenLine() >= declaration.getTokenLine()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Variable '" + entry.getKey() + "' referenced before declaration.", usage, new Object[0]);
        }
    }

    public void leaveFile(AstNode astNode) {
        this.checkCurrentScope();
        this.currentScope = null;
    }

    private static class Scope {
        private final Scope outerScope;
        Map<String, AstNode> firstDeclaration = Maps.newHashMap();
        Map<String, AstNode> firstUsage = Maps.newHashMap();

        public Scope() {
            this.outerScope = null;
        }

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
        }

        private void declare(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            if (!this.firstDeclaration.containsKey(identifier)) {
                this.firstDeclaration.put(identifier, astNode);
            }
        }

        private void use(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            if (!this.firstUsage.containsKey(identifier)) {
                this.firstUsage.put(identifier, astNode);
            }
        }
    }
}

