/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1442", priority=Priority.MAJOR, tags={"cwe", "security", "user-experience"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AlertUseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CALL_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        ExpressionTree callee = ((CallExpressionTree)astNode).callee();
        if (callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && AlertUseCheck.isAlertCall((IdentifierTree)callee)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this usage of alert(...).", astNode, new Object[0]);
        }
    }

    public static boolean isAlertCall(IdentifierTree identifier) {
        return "alert".equals(identifier.name());
    }
}

