/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.statement.CatchBlockTreeImpl;
import org.sonar.javascript.model.implementations.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="BoundOrAssignedEvalOrArguments", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class BoundOrAssignedEvalOrArgumentsCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};
    private static final GrammarRuleKey[] CONST_AND_VAR_NODES = new GrammarRuleKey[]{Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION};

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CATCH_BLOCK, Tree.Kind.FORMAL_PARAMETER_LIST, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT});
        this.subscribeTo((AstNodeType[])CheckUtils.assignmentExpressionArray());
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
        this.subscribeTo((AstNodeType[])CONST_AND_VAR_NODES);
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.checkFunction(astNode);
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.CATCH_BLOCK}) || astNode.is((AstNodeType[])CONST_AND_VAR_NODES)) {
            this.checkVariableDeclaration(astNode);
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            this.checkFormalParamList(astNode);
        } else if (CheckUtils.isAssignmentExpression(astNode)) {
            this.checkModification(astNode.getFirstChild());
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT})) {
            this.checkModification(astNode.getLastChild());
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT})) {
            this.checkModification(astNode.getFirstChild());
        }
    }

    private void checkFunction(AstNode functionNode) {
        AstNode identifier = functionNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER, Tree.Kind.BINDING_IDENTIFIER});
        if (identifier != null && this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("function", identifier.getTokenValue()), identifier, new Object[0]);
        }
    }

    private void checkFormalParamList(AstNode formalParameterList) {
        for (IdentifierTree identifier : ((ParameterListTreeImpl)formalParameterList).parameterIdentifiers()) {
            String identifierName = identifier.name();
            if (!this.isEvalOrArguments(identifierName)) continue;
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("parameter", identifierName), (AstNode)identifier, new Object[0]);
        }
    }

    private void checkVariableDeclaration(AstNode astNode) {
        List identifiers = astNode.is(new AstNodeType[]{Tree.Kind.CATCH_BLOCK}) ? ((CatchBlockTreeImpl)astNode).parameterIdentifiers() : ((VariableDeclarationTreeImpl)astNode).variableIdentifiers();
        for (IdentifierTree identifier : identifiers) {
            String identifierName = identifier.name();
            if (!this.isEvalOrArguments(identifierName)) continue;
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("variable", identifierName), (AstNode)identifier, new Object[0]);
        }
    }

    private void checkModification(AstNode astNode) {
        if (astNode.isNot(new AstNodeType[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION}) && this.isEvalOrArguments(astNode.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the modification of \"" + astNode.getTokenValue() + "\".", astNode, new Object[0]);
        }
    }

    private static String createMessageFor(String name, String value) {
        return "Do not use \"" + value + "\" to declare a " + name + " - use another name.";
    }

    private boolean isEvalOrArguments(String name) {
        return "eval".equals(name) || "arguments".equals(name);
    }
}

