/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.statement.CaseClauseTree;
import org.sonar.javascript.model.interfaces.statement.ElseClauseTree;
import org.sonar.javascript.model.interfaces.statement.IfStatementTree;
import org.sonar.javascript.model.interfaces.statement.SwitchClauseTree;
import org.sonar.javascript.model.interfaces.statement.SwitchStatementTree;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1862", priority=Priority.CRITICAL, tags={"bug", "cert", "pitfall", "unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicateConditionIfElseAndSwitchCasesCheck
extends BaseTreeVisitor {
    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition();
        ElseClauseTree elseClause = tree.elseClause();
        while (elseClause != null && elseClause.statement().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)elseClause.statement();
            if (SyntacticEquivalence.areEquivalent((Tree)condition, (Tree)ifStatement.condition())) {
                this.getContext().addIssue((CodeVisitor)this, (Tree)ifStatement.condition(), "This branch duplicates the one on line " + ((AstNode)condition).getTokenLine() + ".");
            }
            elseClause = ifStatement.elseClause();
        }
        super.visitIfStatement(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        for (int i = 0; i < tree.cases().size(); ++i) {
            for (int j = i + 1; j < tree.cases().size(); ++j) {
                ExpressionTree conditionToCompare;
                ExpressionTree condition = this.getCondition((SwitchClauseTree)tree.cases().get(i));
                if (!SyntacticEquivalence.areEquivalent((Tree)condition, (Tree)(conditionToCompare = this.getCondition((SwitchClauseTree)tree.cases().get(j))))) continue;
                this.getContext().addIssue((CodeVisitor)this, (Tree)conditionToCompare, "This case duplicates the one on line " + ((AstNode)condition).getTokenLine() + ".");
            }
        }
    }

    @Nullable
    private ExpressionTree getCondition(SwitchClauseTree clause) {
        return clause.is(new Tree.Kind[]{Tree.Kind.CASE_CLAUSE}) ? ((CaseClauseTree)clause).expression() : null;
    }
}

