/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="DuplicateFunctionArgument", priority=Priority.CRITICAL, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicateFunctionArgumentCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST});
    }

    public void visitNode(AstNode astNode) {
        HashSet values = Sets.newHashSet();
        for (IdentifierTree identifier : ((ParameterListTreeImpl)astNode).parameterIdentifiers()) {
            this.checkIdentifier((AstNode)identifier, identifier.name(), values);
        }
    }

    private void checkIdentifier(AstNode identifier, String value, Set<String> values) {
        String unescaped = EscapeUtils.unescape(value);
        if (values.contains(unescaped)) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename or remove duplicate function argument '" + value + "'.", identifier, new Object[0]);
        } else {
            values.add(unescaped);
        }
    }
}

