/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="Eval", priority=Priority.MAJOR, tags={"cwe", "injection", "security"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class EvalCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.CALL_EXPRESSION});
    }

    public void visitNode(AstNode node) {
        AstNode simpleCallExprNode = node.getFirstChild();
        AstNode memberExpressionNode = simpleCallExprNode.getFirstChild();
        if (memberExpressionNode.isNot(new AstNodeType[]{Tree.Kind.SUPER}) && "eval".equals(memberExpressionNode.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this use of the \"eval\" function.", node, new Object[0]);
        }
    }
}

