/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.LabelledStatementTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LabelPlacement", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class LabelPlacementCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Tree.Kind[] ITERATION_STATEMENTS = new Tree.Kind[]{Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT};

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.LABELLED_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        LabelledStatementTree labelStatement = (LabelledStatementTree)astNode;
        if (!labelStatement.statement().is(ITERATION_STATEMENTS)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this \"{0}\" label.", astNode, new Object[]{labelStatement.label().name()});
        }
    }
}

