/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="PrimitiveWrappers", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class PrimitiveWrappersCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> WRAPPERS = ImmutableSet.of((Object)"Boolean", (Object)"Number", (Object)"String");

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptKeyword.NEW});
    }

    public void visitNode(AstNode astNode) {
        if (WRAPPERS.contains(astNode.getNextSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Do not use wrapper objects for primitive types.", astNode, new Object[0]);
        }
    }
}

