/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.implementations.statement.SwitchStatementTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1301", priority=Priority.MINOR, tags={"misra"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class SwitchWithNotEnoughCaseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.SWITCH_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        SwitchStatementTreeImpl switchStmt = (SwitchStatementTreeImpl)astNode;
        if (switchStmt.cases().size() < 3) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this \"switch\" statement with \"if\" statements to increase readability.", astNode, new Object[0]);
        }
    }
}

