/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UnusedVariable", priority=Priority.MAJOR, tags={"unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION};
    private static final GrammarRuleKey[] CONST_AND_VAR_NODES = new GrammarRuleKey[]{Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION};
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.FORMAL_PARAMETER_LIST, Tree.Kind.ARROW_FUNCTION});
        this.subscribeTo((AstNodeType[])CONST_AND_VAR_NODES);
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = null;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.currentScope = new Scope(this.currentScope);
        } else if (this.currentScope != null) {
            if (astNode.is(new AstNodeType[]{Tree.Kind.ARROW_FUNCTION})) {
                this.addArrowParametersToScope((ArrowFunctionTree)astNode);
            } else if (astNode.is(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
                this.declareInCurrentScope(((ParameterListTreeImpl)astNode).parameterIdentifiers(), 1);
            } else if (astNode.is((AstNodeType[])CONST_AND_VAR_NODES)) {
                this.declareInCurrentScope(((VariableDeclarationTreeImpl)astNode).variableIdentifiers(), 0);
            } else if (astNode.is(new AstNodeType[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                this.currentScope.use(astNode);
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            for (Map.Entry entry : this.currentScope.variables.entrySet()) {
                if (((Variable)entry.getValue()).usages != 0) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Remove the declaration of the unused '" + (String)entry.getKey() + "' variable.", ((Variable)entry.getValue()).declaration, new Object[0]);
            }
            this.currentScope = this.currentScope.outerScope;
        }
    }

    public void leaveFile(AstNode astNode) {
        this.currentScope = null;
    }

    private void declareInCurrentScope(List<IdentifierTree> identifiers, int usage) {
        for (IdentifierTree identifier : identifiers) {
            this.currentScope.declare(identifier, usage);
        }
    }

    private void addArrowParametersToScope(ArrowFunctionTree arrowFunction) {
        if (arrowFunction.parameters().is(new Tree.Kind[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            for (IdentifierTree identifier : ((ParameterListTreeImpl)arrowFunction.parameters()).parameterIdentifiers()) {
                this.currentScope.declare(identifier, 1);
            }
        } else {
            this.currentScope.declare((IdentifierTree)arrowFunction.parameters(), 1);
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private final Map<String, Variable> variables;

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
            this.variables = Maps.newHashMap();
        }

        private void declare(IdentifierTree identifierTree, int usages) {
            String identifier = identifierTree.name();
            if (!this.variables.containsKey(identifier)) {
                this.variables.put(identifier, new Variable((AstNode)identifierTree, usages));
            }
        }

        private void use(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            Scope scope = this;
            while (scope != null) {
                Variable var = scope.variables.get(identifier);
                if (var != null) {
                    ++var.usages;
                    return;
                }
                scope = scope.outerScope;
            }
            this.variables.put(identifier, new Variable(astNode, 1));
        }
    }

    private static class Variable {
        final AstNode declaration;
        int usages;

        public Variable(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

