/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.flow;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.flow.Statement;

public class Branch {
    private final Branch parent;
    private final int index;
    private int numberOfChildren = 0;
    private Statement stmt;
    private AstNode condition;

    public Branch(Branch parent) {
        this.parent = parent;
        ++this.parent.numberOfChildren;
        this.index = parent.numberOfChildren;
    }

    public Branch() {
        this.parent = null;
        this.index = 1;
    }

    public final void setConditionalStatement(Statement stmt) {
        this.stmt = stmt;
    }

    public final void setCondition(AstNode condition) {
        this.condition = condition;
    }

    public final Statement getConditionalStatement() {
        return this.stmt;
    }

    public final Branch getParent() {
        return this.parent;
    }

    public final AstNode getCondition() {
        return this.condition;
    }

    public final int getDepth() {
        if (this.parent != null) {
            return this.parent.getDepth() + 1;
        }
        return 1;
    }

    public String toString() {
        return "[BRANCH at level " + this.getDepth() + " : " + this.getDepthDetail() + "]";
    }

    public String getDepthDetail() {
        if (this.parent == null) {
            return "" + this.index;
        }
        return this.parent.getDepthDetail() + "." + this.index;
    }

    public boolean isParentOf(Branch branch) {
        Branch branchParent = branch.parent;
        while (branchParent != null) {
            if (branchParent == this) {
                return true;
            }
            branchParent = branchParent.parent;
        }
        return false;
    }

    public boolean isParentOrChildOf(Branch branch) {
        return this.isParentOf(branch) || branch.isParentOf(this);
    }
}

