/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.events;

import com.sonar.sslr.impl.events.Profiler;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilerStream {
    private ProfilerStream() {
    }

    public static long nsToMs(long ns) {
        return ns / 1000000L;
    }

    public static double nsToMs(double ns) {
        return ns / 1000000.0;
    }

    private static <T> List<T> asSortedList(Collection<T> c, Comparator<T> cmp) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list, cmp);
        return list;
    }

    public static void print(Profiler profiler, PrintStream stream) {
        List<Map.Entry<RuleMatcher, Profiler.RuleCounter>> sortedRules = ProfilerStream.asSortedList(profiler.ruleStats.entrySet(), new Comparator<Map.Entry<RuleMatcher, Profiler.RuleCounter>>(){

            @Override
            public int compare(Map.Entry<RuleMatcher, Profiler.RuleCounter> o1, Map.Entry<RuleMatcher, Profiler.RuleCounter> o2) {
                if (o1.getValue().getTotalNonMemoizedHitCpuTime() == o2.getValue().getTotalNonMemoizedHitCpuTime()) {
                    return 0;
                }
                return o1.getValue().getTotalNonMemoizedHitCpuTime() > o2.getValue().getTotalNonMemoizedHitCpuTime() ? -1 : 1;
            }
        });
        stream.println("Lexer CPU time: " + ProfilerStream.nsToMs(profiler.getLexerCpuTime()) + "ms");
        stream.println("Parser CPU time: " + ProfilerStream.nsToMs(profiler.getParserCpuTime()) + "ms");
        stream.println("How many distinct rules were hit: " + profiler.ruleStats.size());
        stream.println("How many times rules were hit: " + profiler.getHits());
        stream.println("How many backtracks: " + profiler.getBacktracks() + " (time avg: " + ProfilerStream.nsToMs(profiler.getAverageBacktrackCpuTime()) + "ms, max: " + ProfilerStream.nsToMs(profiler.getMaxBacktrackCpuTime()) + "ms, lookahead avg: " + String.format("%.2f", profiler.getAverageLookahead()) + ", max: " + profiler.getMaxLookahead() + ")");
        stream.println("Memoizer: " + profiler.getMemoizedHits() + " hits, " + profiler.getMemoizedMisses() + " misses");
        stream.println("Total non memoized hits CPU Time: " + ProfilerStream.nsToMs(profiler.getTotalNonMemoizedHitCpuTime()) + "ms");
        stream.println();
        stream.println("Rule statistics:");
        for (Map.Entry<RuleMatcher, Profiler.RuleCounter> rule : sortedRules) {
            Profiler.RuleCounter counter = rule.getValue();
            stream.print(String.format(" - %-27s", rule.getKey()) + " ");
            stream.print("Hits: " + String.format("%6d", counter.getHits()) + "       ");
            stream.print("Backtracks: " + String.format("%6d", counter.getBacktracks()) + " (time avg: " + String.format("%8.3f", ProfilerStream.nsToMs(counter.getAverageBacktracksCpuTime())) + "ms, max: " + String.format("%5d", ProfilerStream.nsToMs(counter.getMaxBacktrackCpuTime())) + "ms, lookahead avg: " + String.format("%6.2f", counter.getAverageLookahead()) + ", max: " + String.format("%3d", counter.getMaxLookahead()) + ")" + "       ");
            stream.print("Memoizer: " + String.format("%6d", counter.getMemoizedHits()) + " hits, " + String.format("%6d", counter.getMemoizedMisses()) + " misses" + "       ");
            stream.print("Total CPU Time: " + String.format("%6d", ProfilerStream.nsToMs(counter.getTotalNonMemoizedHitCpuTime())) + "ms");
            stream.println();
        }
    }
}

