/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import org.sonar.channel.Channel;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.lexer.EcmaScriptRegexpChannel;

public final class EcmaScriptLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP = "([Pp][+-]?+[0-9_]++)";
    private static final String FLOAT_SUFFIX = "[fFdD]";
    private static final String INT_SUFFIX = "[lL]";

    private EcmaScriptLexer() {
    }

    public static Lexer create() {
        return EcmaScriptLexer.create(new EcmaScriptConfiguration());
    }

    public static Lexer create(EcmaScriptConfiguration conf) {
        return Lexer.builder().withCharset(conf.getCharset()).withFailIfNoChannelToConsumeOneCharacter(true).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{"//[^\\n\\r]*+"})).withChannel((Channel)RegexpChannelBuilder.commentRegexp((String[])new String[]{"/\\*[\\s\\S]*?\\*/"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.LITERAL, (String[])new String[]{"\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\""})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)GenericTokenType.LITERAL, (String[])new String[]{"'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'"})).withChannel((Channel)new EcmaScriptRegexpChannel()).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"[0-9]++[fFdD]"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"0[xX][0-9a-fA-F]++[lL]?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"0[bB][01]++[lL]?+"})).withChannel((Channel)RegexpChannelBuilder.regexp((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (String[])new String[]{"[0-9]++[lL]?+"})).withChannel((Channel)new IdentifierAndKeywordChannel("\\p{javaJavaIdentifierStart}++\\p{javaJavaIdentifierPart}*+", true, (TokenType[][])new TokenType[][]{EcmaScriptKeyword.values()})).withChannel((Channel)new PunctuatorChannel((TokenType[])EcmaScriptPunctuator.values())).withChannel((Channel)new BlackHoleChannel("[\\s]")).build();
    }
}

