/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SourceCodeBuilderCallback;
import com.sonar.sslr.squid.SourceCodeBuilderVisitor;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.SquidAstVisitorContextImpl;
import com.sonar.sslr.squid.metrics.CommentsVisitor;
import com.sonar.sslr.squid.metrics.CounterVisitor;
import com.sonar.sslr.squid.metrics.LinesOfCodeVisitor;
import com.sonar.sslr.squid.metrics.LinesVisitor;
import java.io.File;
import java.util.Collection;
import org.sonar.javascript.CharsetAwareVisitor;
import org.sonar.javascript.EcmaScriptCommentAnalyser;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.parser.EcmaScriptParser;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaScriptAstScanner {
    private JavaScriptAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<EcmaScriptGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<EcmaScriptGrammar> scanner = JavaScriptAstScanner.create(new EcmaScriptConfiguration(Charsets.UTF_8), visitors);
        scanner.scanFile(file);
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<EcmaScriptGrammar> create(EcmaScriptConfiguration conf, SquidAstVisitor<EcmaScriptGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("JavaScript Project"));
        final Parser<EcmaScriptGrammar> parser = EcmaScriptParser.create(conf, new ParsingEventListener[0]);
        AstScanner.Builder builder = AstScanner.builder((SquidAstVisitorContextImpl)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])EcmaScriptMetric.values());
        builder.setCommentAnalyser((CommentAnalyser)new EcmaScriptCommentAnalyser());
        builder.setFilesMetric((MetricDef)EcmaScriptMetric.FILES);
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)parser.getGrammar()).functionDeclaration, ((EcmaScriptGrammar)parser.getGrammar()).functionExpression}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                AstNode identifier = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)parser.getGrammar()).identifier});
                String functionName = identifier == null ? "anonymous" : identifier.getTokenValue();
                String fileKey = parentSourceCode.isType(SourceFile.class) ? parentSourceCode.getKey() : ((SourceFile)parentSourceCode.getParent(SourceFile.class)).getKey();
                SourceFunction function = new SourceFunction(fileKey + ":" + functionName + ":" + astNode.getToken().getLine() + ":" + astNode.getToken().getColumn());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{((EcmaScriptGrammar)parser.getGrammar()).functionDeclaration, ((EcmaScriptGrammar)parser.getGrammar()).functionExpression}));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)EcmaScriptMetric.LINES));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesOfCodeVisitor((MetricDef)EcmaScriptMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)EcmaScriptMetric.COMMENT_LINES).withBlankCommentMetric((MetricDef)EcmaScriptMetric.COMMENT_BLANK_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.STATEMENTS).subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)parser.getGrammar()).variableStatement, ((EcmaScriptGrammar)parser.getGrammar()).emptyStatement, ((EcmaScriptGrammar)parser.getGrammar()).expressionStatement, ((EcmaScriptGrammar)parser.getGrammar()).ifStatement, ((EcmaScriptGrammar)parser.getGrammar()).iterationStatement, ((EcmaScriptGrammar)parser.getGrammar()).continueStatement, ((EcmaScriptGrammar)parser.getGrammar()).breakStatement, ((EcmaScriptGrammar)parser.getGrammar()).returnStatement, ((EcmaScriptGrammar)parser.getGrammar()).withStatement, ((EcmaScriptGrammar)parser.getGrammar()).switchStatement, ((EcmaScriptGrammar)parser.getGrammar()).throwStatement, ((EcmaScriptGrammar)parser.getGrammar()).tryStatement, ((EcmaScriptGrammar)parser.getGrammar()).debuggerStatement}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new ComplexityVisitor());
        for (SquidAstVisitor<EcmaScriptGrammar> visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)visitor).setCharset(conf.getCharset());
            }
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

