/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.sslr.parser.GrammarOperators;

public class EcmaScriptGrammarImpl
extends EcmaScriptGrammar {
    public EcmaScriptGrammarImpl() {
        this.eos.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.optional((Object[])new Object[]{this.semi}), GrammarOperators.next((Object[])new Object[]{this.rcurlybrace}), GrammarOperators.next((Object[])new Object[]{this.eof})})});
        this.eosNoLb.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.optional((Object[])new Object[]{this.semi}), GrammarOperators.next((Object[])new Object[]{this.rcurlybrace}), GrammarOperators.next((Object[])new Object[]{this.eof})})});
        this.identifierName.is(new Object[]{GrammarOperators.token((TokenType)GenericTokenType.IDENTIFIER, (Object)GrammarOperators.regexp((String)"(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")), this.spacing});
        this.literal.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.nullLiteral, this.booleanLiteral, this.numericLiteral, this.stringLiteral, this.regularExpressionLiteral})});
        this.nullLiteral.is(new Object[]{this.nullKeyword});
        this.booleanLiteral.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.trueKeyword, this.falseKeyword})});
        this.lexical();
        this.expressions();
        this.statements();
        this.functionsAndPrograms();
    }

    private void lexical() {
        this.eof.is(new Object[]{GrammarOperators.token((TokenType)GenericTokenType.EOF, (Object)GrammarOperators.endOfInput())}).skip();
        this.identifier.is(new Object[]{GrammarOperators.nextNot((Object[])new Object[]{this.keyword}), GrammarOperators.token((TokenType)GenericTokenType.IDENTIFIER, (Object)GrammarOperators.regexp((String)"(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")), this.spacing});
        this.numericLiteral.is(new Object[]{GrammarOperators.token((TokenType)EcmaScriptTokenType.NUMERIC_LITERAL, (Object)GrammarOperators.regexp((String)"(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)")), this.spacing});
        this.stringLiteral.is(new Object[]{GrammarOperators.token((TokenType)GenericTokenType.LITERAL, (Object)GrammarOperators.regexp((String)"(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')")), this.spacing});
        this.regularExpressionLiteral.is(new Object[]{GrammarOperators.token((TokenType)EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL, (Object)GrammarOperators.regexp((String)"^\\/(?![*/])(?:[^\\\\\\[/\\r\\n\\u2028\\u2029]|\\[(?:[^\\]\\\\\\r\\n\\u2028\\u2029]|\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2}))*+\\]|\\\\(?:[^\\r\\n\\u2028\\u2029ux]|u[0-9A-Fa-f]{1,4}|x[0-9A-Fa-f]{2}))*+\\/\\p{javaJavaIdentifierPart}*+")), this.spacing}).skip();
        this.keyword.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{"null", "true", "false", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "super"}), GrammarOperators.nextNot((Object[])new Object[]{this.letterOrDigit})});
        this.letterOrDigit.is(new Object[]{GrammarOperators.regexp((String)"\\p{javaJavaIdentifierPart}")});
        this.spacing.is(new Object[]{GrammarOperators.regexp((String)"[\\n\\r\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"), GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.token((TokenType)GenericTokenType.COMMENT, (Object)GrammarOperators.regexp((String)"(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), GrammarOperators.regexp((String)"[\\n\\r\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")})}).skip();
        this.punctuators();
        this.keywords();
    }

    private void punctuators() {
        this.lcurlybrace.is(new Object[]{this.punctuator("{")}).skip();
        this.rcurlybrace.is(new Object[]{this.punctuator("}")}).skip();
        this.lparenthesis.is(new Object[]{this.punctuator("(")}).skip();
        this.rparenthesis.is(new Object[]{this.punctuator(")")}).skip();
        this.lbracket.is(new Object[]{this.punctuator("[")}).skip();
        this.rbracket.is(new Object[]{this.punctuator("]")}).skip();
        this.dot.is(new Object[]{this.punctuator(".")}).skip();
        this.semi.is(new Object[]{this.punctuator(";")}).skip();
        this.comma.is(new Object[]{this.punctuator(",")}).skip();
        this.lt.is(new Object[]{this.punctuator("<", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.gt.is(new Object[]{this.punctuator(">", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.le.is(new Object[]{this.punctuator("<=")}).skip();
        this.ge.is(new Object[]{this.punctuator(">=")}).skip();
        this.equal.is(new Object[]{this.punctuator("==", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.notequal.is(new Object[]{this.punctuator("!=", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.equal2.is(new Object[]{this.punctuator("===")}).skip();
        this.notequal2.is(new Object[]{this.punctuator("!==")}).skip();
        this.plus.is(new Object[]{this.punctuator("+", GrammarOperators.nextNot((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{"+", "="})}))}).skip();
        this.minus.is(new Object[]{this.punctuator("-", GrammarOperators.nextNot((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{"-", "="})}))}).skip();
        this.start.is(new Object[]{this.punctuator("*", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.mod.is(new Object[]{this.punctuator("%", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.div.is(new Object[]{this.punctuator("/", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.inc.is(new Object[]{this.punctuator("++")}).skip();
        this.dec.is(new Object[]{this.punctuator("--")}).skip();
        this.sl.is(new Object[]{this.punctuator("<<", GrammarOperators.nextNot((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{"<", "="})}))}).skip();
        this.sr.is(new Object[]{this.punctuator(">>", GrammarOperators.nextNot((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{">", "="})}))}).skip();
        this.sr2.is(new Object[]{this.punctuator(">>>")}).skip();
        this.and.is(new Object[]{this.punctuator("&", GrammarOperators.nextNot((Object[])new Object[]{"&", "="}))}).skip();
        this.or.is(new Object[]{this.punctuator("|", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.xor.is(new Object[]{this.punctuator("^", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.bang.is(new Object[]{this.punctuator("!", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.tilda.is(new Object[]{this.punctuator("~")}).skip();
        this.andand.is(new Object[]{this.punctuator("&&")}).skip();
        this.oror.is(new Object[]{this.punctuator("||")}).skip();
        this.query.is(new Object[]{this.punctuator("?")}).skip();
        this.colon.is(new Object[]{this.punctuator(":")}).skip();
        this.equ.is(new Object[]{this.punctuator("=", GrammarOperators.nextNot((Object[])new Object[]{"="}))}).skip();
        this.plusEqu.is(new Object[]{this.punctuator("+=")}).skip();
        this.minusEqu.is(new Object[]{this.punctuator("-=")}).skip();
        this.divEqu.is(new Object[]{this.punctuator("/=")}).skip();
        this.starEqu.is(new Object[]{this.punctuator("*=")}).skip();
        this.modEqu.is(new Object[]{this.punctuator("%=")}).skip();
        this.slEqu.is(new Object[]{this.punctuator("<<=")}).skip();
        this.srEqu.is(new Object[]{this.punctuator(">>=")}).skip();
        this.srEqu2.is(new Object[]{this.punctuator(">>>=")}).skip();
        this.andEqu.is(new Object[]{this.punctuator("&=")}).skip();
        this.orEqu.is(new Object[]{this.punctuator("|=")}).skip();
        this.xorEqu.is(new Object[]{this.punctuator("^=")}).skip();
    }

    private void keywords() {
        this.nullKeyword.is(new Object[]{this.keyword("null")}).skip();
        this.trueKeyword.is(new Object[]{this.keyword("true")}).skip();
        this.falseKeyword.is(new Object[]{this.keyword("false")}).skip();
        this.breakKeyword.is(new Object[]{this.keyword("break")}).skip();
        this.caseKeyword.is(new Object[]{this.keyword("case")}).skip();
        this.catchKeyword.is(new Object[]{this.keyword("catch")}).skip();
        this.continueKeyword.is(new Object[]{this.keyword("continue")}).skip();
        this.debuggerKeyword.is(new Object[]{this.keyword("debugger")}).skip();
        this.defaultKeyword.is(new Object[]{this.keyword("default")}).skip();
        this.deleteKeyword.is(new Object[]{this.keyword("delete")}).skip();
        this.doKeyword.is(new Object[]{this.keyword("do")}).skip();
        this.elseKeyword.is(new Object[]{this.keyword("else")}).skip();
        this.finallyKeyword.is(new Object[]{this.keyword("finally")}).skip();
        this.forKeyword.is(new Object[]{this.keyword("for")}).skip();
        this.functionKeyword.is(new Object[]{this.keyword("function")}).skip();
        this.ifKeyword.is(new Object[]{this.keyword("if")}).skip();
        this.inKeyword.is(new Object[]{this.keyword("in")}).skip();
        this.instanceofKeyword.is(new Object[]{this.keyword("instanceof")}).skip();
        this.newKeyword.is(new Object[]{this.keyword("new")}).skip();
        this.returnKeyword.is(new Object[]{this.keyword("return")}).skip();
        this.switchKeyword.is(new Object[]{this.keyword("switch")}).skip();
        this.thisKeyword.is(new Object[]{this.keyword("this")}).skip();
        this.throwKeyword.is(new Object[]{this.keyword("throw")}).skip();
        this.tryKeyword.is(new Object[]{this.keyword("try")}).skip();
        this.typeofKeyword.is(new Object[]{this.keyword("typeof")}).skip();
        this.varKeyword.is(new Object[]{this.keyword("var")}).skip();
        this.voidKeyword.is(new Object[]{this.keyword("void")}).skip();
        this.whileKeyword.is(new Object[]{this.keyword("while")}).skip();
        this.withKeyword.is(new Object[]{this.keyword("with")}).skip();
        this.classKeyword.is(new Object[]{this.keyword("class")}).skip();
        this.constKeyword.is(new Object[]{this.keyword("const")}).skip();
        this.enumKeyword.is(new Object[]{this.keyword("enum")}).skip();
        this.exportKeyword.is(new Object[]{this.keyword("export")}).skip();
        this.extendsKeyword.is(new Object[]{this.keyword("extends")}).skip();
        this.superKeyword.is(new Object[]{this.keyword("super")}).skip();
    }

    private Object keyword(String value) {
        for (EcmaScriptKeyword tokenType : EcmaScriptKeyword.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            return GrammarOperators.sequence((Object[])new Object[]{GrammarOperators.token((TokenType)tokenType, (Object)value), GrammarOperators.nextNot((Object[])new Object[]{this.letterOrDigit}), this.spacing});
        }
        throw new IllegalStateException(value);
    }

    private Object punctuator(String value) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            return GrammarOperators.sequence((Object[])new Object[]{GrammarOperators.token((TokenType)tokenType, (Object)value), this.spacing});
        }
        throw new IllegalStateException(value);
    }

    private Object word(String value) {
        return GrammarOperators.sequence((Object[])new Object[]{GrammarOperators.token((TokenType)GenericTokenType.IDENTIFIER, (Object)value), this.spacing});
    }

    private Object punctuator(String value, Object element) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            return GrammarOperators.sequence((Object[])new Object[]{GrammarOperators.token((TokenType)tokenType, (Object)value), element, this.spacing});
        }
        throw new IllegalStateException(value);
    }

    private void expressions() {
        this.primaryExpression.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.thisKeyword, this.identifier, this.literal, this.arrayLiteral, this.objectLiteral, GrammarOperators.sequence((Object[])new Object[]{this.lparenthesis, this.expression, this.rparenthesis})})});
        this.arrayLiteral.is(new Object[]{this.lbracket, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.comma, this.assignmentExpression})}), this.rbracket});
        this.objectLiteral.is(new Object[]{this.lcurlybrace, GrammarOperators.optional((Object[])new Object[]{this.propertyAssignment, GrammarOperators.zeroOrMore((Object[])new Object[]{this.comma, this.propertyAssignment}), GrammarOperators.optional((Object[])new Object[]{this.comma})}), this.rcurlybrace});
        this.propertyAssignment.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.propertyName, this.colon, this.assignmentExpression}), GrammarOperators.sequence((Object[])new Object[]{this.word("get"), this.propertyName, this.lparenthesis, this.rparenthesis, this.lcurlybrace, this.functionBody, this.rcurlybrace}), GrammarOperators.sequence((Object[])new Object[]{this.word("set"), this.propertyName, this.lparenthesis, this.propertySetParameterList, this.rparenthesis, this.lcurlybrace, this.functionBody, this.rcurlybrace})})});
        this.propertyName.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.identifierName, this.stringLiteral, this.numericLiteral})});
        this.propertySetParameterList.is(new Object[]{this.identifier});
        this.memberExpression.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.primaryExpression, this.functionExpression, GrammarOperators.sequence((Object[])new Object[]{this.newKeyword, this.memberExpression, this.arguments})}), GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.lbracket, this.expression, this.rbracket}), GrammarOperators.sequence((Object[])new Object[]{this.dot, this.identifierName})})})});
        this.newExpression.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.memberExpression, GrammarOperators.sequence((Object[])new Object[]{this.newKeyword, this.newExpression})})});
        this.callExpression.is(new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.memberExpression, this.arguments}), GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.arguments, GrammarOperators.sequence((Object[])new Object[]{this.lbracket, this.expression, this.rbracket}), GrammarOperators.sequence((Object[])new Object[]{this.dot, this.identifierName})})})});
        this.arguments.is(new Object[]{this.lparenthesis, GrammarOperators.optional((Object[])new Object[]{this.assignmentExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{this.comma, this.assignmentExpression})}), this.rparenthesis});
        this.leftHandSideExpression.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.callExpression, this.newExpression})});
        this.postfixExpression.is(new Object[]{this.leftHandSideExpression, GrammarOperators.optional((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.inc, this.dec})})});
        this.unaryExpression.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.postfixExpression, GrammarOperators.sequence((Object[])new Object[]{this.deleteKeyword, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.voidKeyword, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.typeofKeyword, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.inc, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.dec, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.plus, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.minus, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.tilda, this.unaryExpression}), GrammarOperators.sequence((Object[])new Object[]{this.bang, this.unaryExpression})})});
        this.multiplicativeExpression.is(new Object[]{this.unaryExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.start, this.div, this.mod}), this.unaryExpression})}).skipIfOneChild();
        this.additiveExpression.is(new Object[]{this.multiplicativeExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.plus, this.minus}), this.multiplicativeExpression})}).skipIfOneChild();
        this.shiftExpression.is(new Object[]{this.additiveExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.sl, this.sr, this.sr2}), this.additiveExpression})}).skipIfOneChild();
        this.relationalExpression.is(new Object[]{this.shiftExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.lt, this.gt, this.le, this.ge, this.instanceofKeyword, this.inKeyword}), this.shiftExpression})}).skipIfOneChild();
        this.relationalExpressionNoIn.is(new Object[]{this.shiftExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.lt, this.gt, this.le, this.ge, this.instanceofKeyword}), this.shiftExpression})}).skipIfOneChild();
        this.equalityExpression.is(new Object[]{this.relationalExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.equal, this.notequal, this.equal2, this.notequal2}), this.relationalExpression})}).skipIfOneChild();
        this.equalityExpressionNoIn.is(new Object[]{this.relationalExpressionNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.equal, this.notequal, this.equal2, this.notequal2}), this.relationalExpressionNoIn})}).skipIfOneChild();
        this.bitwiseAndExpression.is(new Object[]{this.equalityExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{this.and, this.equalityExpression})}).skipIfOneChild();
        this.bitwiseAndExpressionNoIn.is(new Object[]{this.equalityExpressionNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{this.and, this.equalityExpressionNoIn})}).skipIfOneChild();
        this.bitwiseXorExpression.is(new Object[]{this.bitwiseAndExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{this.xor, this.bitwiseAndExpression})}).skipIfOneChild();
        this.bitwiseXorExpressionNoIn.is(new Object[]{this.bitwiseAndExpressionNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{this.xor, this.bitwiseAndExpressionNoIn})}).skipIfOneChild();
        this.bitwiseOrExpression.is(new Object[]{this.bitwiseXorExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{this.or, this.bitwiseXorExpression})}).skipIfOneChild();
        this.bitwiseOrExpressionNoIn.is(new Object[]{this.bitwiseXorExpressionNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{this.or, this.bitwiseXorExpressionNoIn})}).skipIfOneChild();
        this.logicalAndExpression.is(new Object[]{this.bitwiseOrExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{this.andand, this.bitwiseOrExpression})}).skipIfOneChild();
        this.logicalAndExpressionNoIn.is(new Object[]{this.bitwiseOrExpressionNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{this.andand, this.bitwiseOrExpressionNoIn})}).skipIfOneChild();
        this.logicalOrExpression.is(new Object[]{this.logicalAndExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{this.oror, this.logicalAndExpression})}).skipIfOneChild();
        this.logicalOrExpressionNoIn.is(new Object[]{this.logicalAndExpressionNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{this.oror, this.logicalAndExpressionNoIn})}).skipIfOneChild();
        this.conditionalExpression.is(new Object[]{this.logicalOrExpression, GrammarOperators.optional((Object[])new Object[]{this.query, this.assignmentExpression, this.colon, this.assignmentExpression})}).skipIfOneChild();
        this.conditionalExpressionNoIn.is(new Object[]{this.logicalOrExpressionNoIn, GrammarOperators.optional((Object[])new Object[]{this.query, this.assignmentExpression, this.colon, this.assignmentExpressionNoIn})}).skipIfOneChild();
        this.assignmentExpression.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.leftHandSideExpression, this.assignmentOperator, this.assignmentExpression}), this.conditionalExpression})}).skipIfOneChild();
        this.assignmentExpressionNoIn.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.leftHandSideExpression, this.assignmentOperator, this.assignmentExpressionNoIn}), this.conditionalExpressionNoIn})}).skipIfOneChild();
        this.assignmentOperator.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.equ, this.starEqu, this.divEqu, this.modEqu, this.plusEqu, this.minusEqu, this.slEqu, this.srEqu, this.srEqu2, this.andEqu, this.xorEqu, this.orEqu})});
        this.expression.is(new Object[]{this.assignmentExpression, GrammarOperators.zeroOrMore((Object[])new Object[]{this.comma, this.assignmentExpression})});
        this.expressionNoIn.is(new Object[]{this.assignmentExpressionNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{this.comma, this.assignmentExpressionNoIn})});
    }

    private void statements() {
        this.statement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.block, this.variableStatement, this.emptyStatement, this.labelledStatement, this.expressionStatement, this.ifStatement, this.iterationStatement, this.continueStatement, this.breakStatement, this.returnStatement, this.withStatement, this.switchStatement, this.throwStatement, this.tryStatement, this.debuggerStatement})});
        this.block.is(new Object[]{this.lcurlybrace, GrammarOperators.optional((Object[])new Object[]{this.statementList}), this.rcurlybrace});
        this.statementList.is(new Object[]{GrammarOperators.oneOrMore((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.statement, EcmaScriptGrammarImpl.permissive(this.functionDeclaration)})})});
        this.variableStatement.is(new Object[]{this.varKeyword, this.variableDeclarationList, this.eos});
        this.variableDeclarationList.is(new Object[]{this.variableDeclaration, GrammarOperators.zeroOrMore((Object[])new Object[]{this.comma, this.variableDeclaration})});
        this.variableDeclarationListNoIn.is(new Object[]{this.variableDeclarationNoIn, GrammarOperators.zeroOrMore((Object[])new Object[]{this.comma, this.variableDeclarationNoIn})});
        this.variableDeclaration.is(new Object[]{this.identifier, GrammarOperators.optional((Object[])new Object[]{this.initialiser})});
        this.variableDeclarationNoIn.is(new Object[]{this.identifier, GrammarOperators.optional((Object[])new Object[]{this.initialiserNoIn})});
        this.initialiser.is(new Object[]{this.equ, this.assignmentExpression});
        this.initialiserNoIn.is(new Object[]{this.equ, this.assignmentExpressionNoIn});
        this.emptyStatement.is(new Object[]{this.semi});
        this.expressionStatement.is(new Object[]{GrammarOperators.nextNot((Object[])new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.lcurlybrace, this.functionKeyword})}), this.expression, this.eos});
        this.condition.is(new Object[]{this.expression});
        this.ifStatement.is(new Object[]{this.ifKeyword, this.lparenthesis, this.condition, this.rparenthesis, this.statement, GrammarOperators.optional((Object[])new Object[]{this.elseClause})});
        this.elseClause.is(new Object[]{this.elseKeyword, this.statement});
        this.iterationStatement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.doWhileStatement, this.whileStatement, this.forInStatement, this.forStatement})});
        this.doWhileStatement.is(new Object[]{this.doKeyword, this.statement, this.whileKeyword, this.lparenthesis, this.condition, this.rparenthesis, this.eos});
        this.whileStatement.is(new Object[]{this.whileKeyword, this.lparenthesis, this.condition, this.rparenthesis, this.statement});
        this.forInStatement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.forKeyword, this.lparenthesis, this.leftHandSideExpression, this.inKeyword, this.expression, this.rparenthesis, this.statement}), GrammarOperators.sequence((Object[])new Object[]{this.forKeyword, this.lparenthesis, this.varKeyword, this.variableDeclarationListNoIn, this.inKeyword, this.expression, this.rparenthesis, this.statement})})});
        this.forStatement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.forKeyword, this.lparenthesis, GrammarOperators.optional((Object[])new Object[]{this.expressionNoIn}), this.semi, GrammarOperators.optional((Object[])new Object[]{this.condition}), this.semi, GrammarOperators.optional((Object[])new Object[]{this.expression}), this.rparenthesis, this.statement}), GrammarOperators.sequence((Object[])new Object[]{this.forKeyword, this.lparenthesis, this.varKeyword, this.variableDeclarationListNoIn, this.semi, GrammarOperators.optional((Object[])new Object[]{this.condition}), this.semi, GrammarOperators.optional((Object[])new Object[]{this.expression}), this.rparenthesis, this.statement})})});
        this.continueStatement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.continueKeyword, this.identifier, this.eos}), GrammarOperators.sequence((Object[])new Object[]{this.continueKeyword, this.eosNoLb})})});
        this.breakStatement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.breakKeyword, this.identifier, this.eos}), GrammarOperators.sequence((Object[])new Object[]{this.breakKeyword, this.eosNoLb})})});
        this.returnStatement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.returnKeyword, this.expression, this.eos}), GrammarOperators.sequence((Object[])new Object[]{this.returnKeyword, this.eosNoLb})})});
        this.withStatement.is(new Object[]{this.withKeyword, this.lparenthesis, this.expression, this.rparenthesis, this.statement});
        this.switchStatement.is(new Object[]{this.switchKeyword, this.lparenthesis, this.expression, this.rparenthesis, this.caseBlock});
        this.caseBlock.is(new Object[]{this.lcurlybrace, GrammarOperators.optional((Object[])new Object[]{this.caseClauses}), GrammarOperators.optional((Object[])new Object[]{this.defaultClause, GrammarOperators.optional((Object[])new Object[]{this.caseClauses})}), this.rcurlybrace});
        this.caseClauses.is(new Object[]{GrammarOperators.oneOrMore((Object[])new Object[]{this.caseClause})});
        this.caseClause.is(new Object[]{this.caseKeyword, this.expression, this.colon, GrammarOperators.optional((Object[])new Object[]{this.statementList})});
        this.defaultClause.is(new Object[]{this.defaultKeyword, this.colon, GrammarOperators.optional((Object[])new Object[]{this.statementList})});
        this.labelledStatement.is(new Object[]{this.identifier, this.colon, this.statement});
        this.throwStatement.is(new Object[]{this.throwKeyword, this.expression, this.eos});
        this.tryStatement.is(new Object[]{this.tryKeyword, this.block, GrammarOperators.firstOf((Object[])new Object[]{GrammarOperators.sequence((Object[])new Object[]{this.catch_, GrammarOperators.optional((Object[])new Object[]{this.finally_})}), this.finally_})});
        this.catch_.is(new Object[]{this.catchKeyword, this.lparenthesis, this.identifier, this.rparenthesis, this.block});
        this.finally_.is(new Object[]{this.finallyKeyword, this.block});
        this.debuggerStatement.is(new Object[]{this.debuggerKeyword, this.eos});
    }

    private void functionsAndPrograms() {
        this.functionDeclaration.is(new Object[]{this.functionKeyword, this.identifier, this.lparenthesis, GrammarOperators.optional((Object[])new Object[]{this.formalParameterList}), this.rparenthesis, this.lcurlybrace, this.functionBody, this.rcurlybrace});
        this.functionExpression.is(new Object[]{this.functionKeyword, GrammarOperators.optional((Object[])new Object[]{this.identifier}), this.lparenthesis, GrammarOperators.optional((Object[])new Object[]{this.formalParameterList}), this.rparenthesis, this.lcurlybrace, this.functionBody, this.rcurlybrace});
        this.formalParameterList.is(new Object[]{this.identifier, GrammarOperators.zeroOrMore((Object[])new Object[]{this.comma, this.identifier})});
        this.functionBody.is(new Object[]{GrammarOperators.optional((Object[])new Object[]{this.sourceElements})});
        this.program.is(new Object[]{GrammarOperators.optional((Object[])new Object[]{this.shebang}), this.spacing, GrammarOperators.optional((Object[])new Object[]{this.sourceElements}), this.eof});
        this.sourceElements.is(new Object[]{GrammarOperators.oneOrMore((Object[])new Object[]{this.sourceElement})});
        this.sourceElement.is(new Object[]{GrammarOperators.firstOf((Object[])new Object[]{this.statement, this.functionDeclaration})});
        this.shebang.is(new Object[]{"#!", GrammarOperators.regexp((String)"[^\\n\\r]*+")}).skip();
    }

    private static Object permissive(Object object) {
        return object;
    }
}

