/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.parser.AstNodeReflector;
import org.sonar.javascript.model.interfaces.Tree;

public abstract class JavaScriptTree
extends AstNode
implements Tree {
    private static final AstNodeType NULL_NODE = new AstNodeType(){

        public String toString() {
            return "[null]";
        }
    };
    private final AstNode astNode;

    public JavaScriptTree(AstNodeType type) {
        super(type, type.toString(), null);
        this.astNode = this;
    }

    public JavaScriptTree(AstNodeType type, Token token) {
        super(type, type.toString(), token);
        this.astNode = this;
    }

    public JavaScriptTree(@Nullable AstNode astNode) {
        super(astNode == null ? NULL_NODE : astNode.getType(), astNode == null ? NULL_NODE.toString() : astNode.getType().toString(), astNode == null ? null : astNode.getToken());
        this.astNode = astNode;
    }

    public boolean isLegacy() {
        return this.astNode != this;
    }

    private void prependChild(AstNode astNode) {
        Preconditions.checkState((this.getAstNode() == this ? 1 : 0) != 0, (Object)"Legacy strongly typed node");
        List children = this.getChildren();
        if (children.isEmpty()) {
            this.addChild(astNode);
        } else {
            AstNodeReflector.setParent(astNode, this);
            children.add(0, astNode);
            for (int i = 0; i < children.size(); ++i) {
                AstNodeReflector.setChildIndex((AstNode)children.get(i), i);
            }
        }
    }

    public void prependChildren(AstNode ... astNodes) {
        for (int i = astNodes.length - 1; i >= 0; --i) {
            this.prependChild(astNodes[i]);
        }
    }

    public void prependChildren(List<? extends AstNode> astNodes) {
        this.prependChildren(astNodes.toArray(new AstNode[astNodes.size()]));
    }

    public void addChild(AstNode child) {
        Preconditions.checkState((!this.isLegacy() ? 1 : 0) != 0, (Object)"Children should not be added to legacy nodes");
        super.addChild(child);
    }

    public void addChildren(AstNode ... children) {
        Preconditions.checkState((!this.isLegacy() ? 1 : 0) != 0, (Object)"Children should not be added to legacy nodes");
        for (AstNode child : children) {
            super.addChild(child);
        }
    }

    public AstNode getAstNode() {
        return this.astNode;
    }

    public int getLine() {
        return this.astNode.getTokenLine();
    }

    @Override
    public final boolean is(Tree.Kind ... kind) {
        if (this.getKind() != null) {
            for (Tree.Kind kindIter : kind) {
                if (this.getKind() != kindIter) continue;
                return true;
            }
        }
        return false;
    }

    public abstract AstNodeType getKind();

    public abstract Iterator<Tree> childrenIterator();

    public boolean isLeaf() {
        return false;
    }
}

