/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ConditionalExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class ConditionalExpressionTreeImpl
extends JavaScriptTree
implements ConditionalExpressionTree {
    private ExpressionTree condition;
    private final SyntaxToken query;
    private final ExpressionTree trueExpression;
    private final SyntaxToken colon;
    private final ExpressionTree falseExpression;

    public ConditionalExpressionTreeImpl(InternalSyntaxToken query, ExpressionTree trueExpression, InternalSyntaxToken colon, ExpressionTree falseExpression) {
        super(Tree.Kind.CONDITIONAL_EXPRESSION);
        this.query = query;
        this.trueExpression = trueExpression;
        this.colon = colon;
        this.falseExpression = falseExpression;
        this.addChildren(query, (AstNode)trueExpression, colon, (AstNode)falseExpression);
    }

    public ConditionalExpressionTreeImpl complete(ExpressionTree condition) {
        this.condition = condition;
        this.prependChildren((AstNode)condition);
        return this;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken query() {
        return this.query;
    }

    @Override
    public ExpressionTree trueExpression() {
        return this.trueExpression;
    }

    @Override
    public SyntaxToken colon() {
        return this.colon;
    }

    @Override
    public ExpressionTree falseExpression() {
        return this.falseExpression;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONDITIONAL_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.trueExpression, this.falseExpression});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }
}

