/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.CaseClauseTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;

public class CaseClauseTreeImpl
extends JavaScriptTree
implements CaseClauseTree {
    private final SyntaxToken caseKeyword;
    private final ExpressionTree expression;
    private final SyntaxToken colon;
    private final List<StatementTree> statements;

    public CaseClauseTreeImpl(InternalSyntaxToken caseKeyword, ExpressionTree expression, InternalSyntaxToken colon) {
        super(Tree.Kind.CASE_CLAUSE);
        this.caseKeyword = caseKeyword;
        this.expression = expression;
        this.colon = colon;
        this.statements = ListUtils.EMPTY_LIST;
        this.addChildren(caseKeyword, (AstNode)expression, colon);
    }

    public CaseClauseTreeImpl(InternalSyntaxToken caseKeyword, ExpressionTree expression, InternalSyntaxToken colon, List<StatementTree> statements) {
        super(Tree.Kind.CASE_CLAUSE);
        this.caseKeyword = caseKeyword;
        this.expression = expression;
        this.colon = colon;
        this.statements = statements;
        this.addChildren(caseKeyword, (AstNode)expression, colon);
        for (StatementTree child : statements) {
            this.addChild((AstNode)child);
        }
    }

    @Override
    public SyntaxToken keyword() {
        return this.caseKeyword;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken colon() {
        return this.colon;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.CASE_CLAUSE;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.expression), this.statements.iterator());
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCaseClause(this);
    }
}

