/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.DoWhileStatementTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;

public class DoWhileStatementTreeImpl
extends JavaScriptTree
implements DoWhileStatementTree {
    private final SyntaxToken doKeyword;
    private final SyntaxToken whileKeyword;
    private final SyntaxToken openingParenthesis;
    private final ExpressionTree condition;
    private final SyntaxToken closingParenthesis;
    private final StatementTree statement;

    public DoWhileStatementTreeImpl(InternalSyntaxToken doKeyword, StatementTree statement, InternalSyntaxToken whileKeyword, InternalSyntaxToken openingParenthesis, ExpressionTree condition, InternalSyntaxToken closingParenthesis, AstNode eos) {
        super(Tree.Kind.DO_WHILE_STATEMENT);
        this.doKeyword = doKeyword;
        this.whileKeyword = whileKeyword;
        this.openingParenthesis = openingParenthesis;
        this.condition = condition;
        this.closingParenthesis = closingParenthesis;
        this.statement = statement;
        this.addChildren(doKeyword, (AstNode)statement, whileKeyword, openingParenthesis, (AstNode)condition, closingParenthesis, eos);
    }

    @Override
    public SyntaxToken whileKeyword() {
        return this.whileKeyword;
    }

    @Override
    public SyntaxToken doKeyword() {
        return this.doKeyword;
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openingParenthesis;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closingParenthesis;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public SyntaxToken endOfStatement() {
        throw new UnsupportedOperationException("Not supported yet in the strongly typed AST.");
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.DO_WHILE_STATEMENT;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.statement});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitDoWhileStatement(this);
    }
}

