/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.ElseClauseTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;

public class ElseClauseTreeImpl
extends JavaScriptTree
implements ElseClauseTree {
    private SyntaxToken elseKeyword;
    private final StatementTree statement;

    public ElseClauseTreeImpl(InternalSyntaxToken elseKeyword, StatementTree statement) {
        super(Tree.Kind.ELSE_CLAUSE);
        this.elseKeyword = elseKeyword;
        this.statement = statement;
        this.addChildren(elseKeyword, (AstNode)statement);
    }

    @Override
    public SyntaxToken elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    @Nullable
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.ELSE_CLAUSE;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.statement);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitElseClause(this);
    }
}

