/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.resolve;

import java.util.List;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolDeclaration;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.implementations.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.expression.ArrowFunctionTreeImpl;
import org.sonar.javascript.model.implementations.statement.CatchBlockTreeImpl;
import org.sonar.javascript.model.implementations.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.BindingElementTree;
import org.sonar.javascript.model.interfaces.declaration.FunctionDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.MethodDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.FunctionExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.statement.CatchBlockTree;
import org.sonar.javascript.model.interfaces.statement.VariableDeclarationTree;

public class SymbolDeclarationVisitor
extends BaseTreeVisitor {
    private SymbolModel symbolModel;
    private Scope currentScope;

    public SymbolDeclarationVisitor(SymbolModel symbolModel) {
        this.symbolModel = symbolModel;
        this.currentScope = null;
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.newScope(tree);
        super.visitScript(tree);
        this.leaveScope();
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.newScope(tree);
        this.addSymbols(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers(), SymbolDeclaration.Kind.PARAMETER, Symbol.Kind.PARAMETER);
        this.addFunctionBuildInSymbols();
        super.visitMethodDeclaration(tree);
        this.leaveScope();
    }

    private void addFunctionBuildInSymbols() {
        String arguments = "arguments";
        if (this.currentScope.symbols.get(arguments) == null) {
            this.createBuildInSymbolForScope(arguments, this.currentScope, Symbol.Kind.VARIABLE);
        }
    }

    private void createBuildInSymbolForScope(String name, Scope scope, Symbol.Kind kind) {
        Symbol symbol = scope.createBuildInSymbol(name, kind);
        this.symbolModel.setScopeForSymbol(symbol, scope);
        this.symbolModel.setScopeFor(scope.getTree(), scope);
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.newScope(tree);
        this.addSymbols(((CatchBlockTreeImpl)tree).parameterIdentifiers(), SymbolDeclaration.Kind.CATCH_BLOCK, Symbol.Kind.VARIABLE);
        super.visitCatchBlock(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.addSymbol(tree.name().name(), new SymbolDeclaration(tree.name(), SymbolDeclaration.Kind.FUNCTION_DECLARATION), Symbol.Kind.FUNCTION);
        this.newScope(tree);
        this.addSymbols(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers(), SymbolDeclaration.Kind.PARAMETER, Symbol.Kind.PARAMETER);
        this.addFunctionBuildInSymbols();
        super.visitFunctionDeclaration(tree);
        this.leaveScope();
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.newScope(tree);
        this.addSymbols(((ArrowFunctionTreeImpl)tree).parameterIdentifiers(), SymbolDeclaration.Kind.PARAMETER, Symbol.Kind.PARAMETER);
        this.addFunctionBuildInSymbols();
        super.visitArrowFunction(tree);
        this.leaveScope();
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.newScope(tree);
        IdentifierTree name = tree.name();
        if (name != null) {
            this.addSymbol(name.name(), new SymbolDeclaration(name, SymbolDeclaration.Kind.FUNCTION_EXPRESSION), Symbol.Kind.FUNCTION);
        }
        this.addSymbols(((ParameterListTreeImpl)tree.parameters()).parameterIdentifiers(), SymbolDeclaration.Kind.PARAMETER, Symbol.Kind.PARAMETER);
        this.addFunctionBuildInSymbols();
        super.visitFunctionExpression(tree);
        this.leaveScope();
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.addSymbols(((VariableDeclarationTreeImpl)tree).variableIdentifiers(), SymbolDeclaration.Kind.VARIABLE_DECLARATION, Symbol.Kind.VARIABLE);
        this.addUsages(tree);
        super.visitVariableDeclaration(tree);
    }

    public void addUsages(VariableDeclarationTree tree) {
        for (BindingElementTree bindingElement : tree.variables()) {
            if (!bindingElement.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) continue;
            for (IdentifierTree identifier : ((InitializedBindingElementTreeImpl)bindingElement).bindingIdentifiers()) {
                Usage.createInit(this.symbolModel, this.currentScope.lookupSymbol(identifier.name()), identifier, bindingElement, Usage.Kind.WRITE);
            }
        }
    }

    private void leaveScope() {
        if (this.currentScope != null) {
            this.currentScope = this.currentScope.outer();
        }
    }

    private void setScopeForTree(Tree tree) {
        this.symbolModel.setScopeFor(tree, this.currentScope);
    }

    private void addSymbol(String name, SymbolDeclaration declaration, Symbol.Kind kind) {
        Symbol symbol = this.currentScope.createSymbol(name, declaration, kind);
        this.symbolModel.setScopeForSymbol(symbol, this.currentScope);
        this.setScopeForTree(declaration.tree());
    }

    private void addSymbols(List<IdentifierTree> identifiers, SymbolDeclaration.Kind declarationKind, Symbol.Kind symbolKind) {
        for (IdentifierTree identifier : identifiers) {
            this.addSymbol(identifier.name(), new SymbolDeclaration(identifier, declarationKind), symbolKind);
        }
    }

    private void newScope(Tree tree) {
        this.currentScope = new Scope(this.currentScope, tree);
        this.setScopeForTree(tree);
    }
}

