/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.visitors;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.JavaScriptFileScanner;
import org.sonar.javascript.ast.visitors.AstTreeVisitorContext;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.expression.SuperTreeImpl;
import org.sonar.javascript.model.interfaces.ModuleTree;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ArrayBindingPatternTree;
import org.sonar.javascript.model.interfaces.declaration.BindingPropertyTree;
import org.sonar.javascript.model.interfaces.declaration.DefaultExportDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ExportClauseTree;
import org.sonar.javascript.model.interfaces.declaration.FromClauseTree;
import org.sonar.javascript.model.interfaces.declaration.FunctionDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ImportClauseTree;
import org.sonar.javascript.model.interfaces.declaration.ImportDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ImportModuleDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.InitializedBindingElementTree;
import org.sonar.javascript.model.interfaces.declaration.MethodDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.NameSpaceExportDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.NamedExportDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ObjectBindingPatternTree;
import org.sonar.javascript.model.interfaces.declaration.ParameterListTree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.javascript.model.interfaces.declaration.SpecifierListTree;
import org.sonar.javascript.model.interfaces.declaration.SpecifierTree;
import org.sonar.javascript.model.interfaces.expression.ArrayLiteralTree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ClassTree;
import org.sonar.javascript.model.interfaces.expression.ComputedPropertyNameTree;
import org.sonar.javascript.model.interfaces.expression.ConditionalExpressionTree;
import org.sonar.javascript.model.interfaces.expression.FunctionExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.LiteralTree;
import org.sonar.javascript.model.interfaces.expression.MemberExpressionTree;
import org.sonar.javascript.model.interfaces.expression.NewExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ObjectLiteralTree;
import org.sonar.javascript.model.interfaces.expression.PairPropertyTree;
import org.sonar.javascript.model.interfaces.expression.ParenthesisedExpressionTree;
import org.sonar.javascript.model.interfaces.expression.RestElementTree;
import org.sonar.javascript.model.interfaces.expression.TaggedTemplateTree;
import org.sonar.javascript.model.interfaces.expression.TemplateCharactersTree;
import org.sonar.javascript.model.interfaces.expression.TemplateExpressionTree;
import org.sonar.javascript.model.interfaces.expression.TemplateLiteralTree;
import org.sonar.javascript.model.interfaces.expression.ThisTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.YieldExpressionTree;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.javascript.model.interfaces.statement.BreakStatementTree;
import org.sonar.javascript.model.interfaces.statement.CaseClauseTree;
import org.sonar.javascript.model.interfaces.statement.CatchBlockTree;
import org.sonar.javascript.model.interfaces.statement.ContinueStatementTree;
import org.sonar.javascript.model.interfaces.statement.DebuggerStatementTree;
import org.sonar.javascript.model.interfaces.statement.DefaultClauseTree;
import org.sonar.javascript.model.interfaces.statement.DoWhileStatementTree;
import org.sonar.javascript.model.interfaces.statement.ElseClauseTree;
import org.sonar.javascript.model.interfaces.statement.EmptyStatementTree;
import org.sonar.javascript.model.interfaces.statement.ExpressionStatementTree;
import org.sonar.javascript.model.interfaces.statement.ForInStatementTree;
import org.sonar.javascript.model.interfaces.statement.ForOfStatementTree;
import org.sonar.javascript.model.interfaces.statement.ForStatementTree;
import org.sonar.javascript.model.interfaces.statement.IfStatementTree;
import org.sonar.javascript.model.interfaces.statement.LabelledStatementTree;
import org.sonar.javascript.model.interfaces.statement.ReturnStatementTree;
import org.sonar.javascript.model.interfaces.statement.SwitchStatementTree;
import org.sonar.javascript.model.interfaces.statement.ThrowStatementTree;
import org.sonar.javascript.model.interfaces.statement.TryStatementTree;
import org.sonar.javascript.model.interfaces.statement.VariableDeclarationTree;
import org.sonar.javascript.model.interfaces.statement.VariableStatementTree;
import org.sonar.javascript.model.interfaces.statement.WhileStatementTree;
import org.sonar.javascript.model.interfaces.statement.WithStatementTree;
import org.sonar.javascript.parser.sslr.Optional;

public class BaseTreeVisitor
implements TreeVisitor,
JavaScriptFileScanner {
    private AstTreeVisitorContext context = null;

    public AstTreeVisitorContext getContext() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"this#scanFile(context) should be called to initialised the context before accessing it");
        return this.context;
    }

    @Override
    public void scanFile(AstTreeVisitorContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    protected <T> void scan(List<T> trees) {
        for (T tree : trees) {
            if (tree instanceof Optional) {
                this.scan((Optional)tree);
                continue;
            }
            if (tree instanceof Tree) {
                this.scan((Tree)tree);
                continue;
            }
            throw new IllegalArgumentException("List element type should be of type Optional or Tree.");
        }
    }

    private void scan(Optional<Tree> tree) {
        if (tree.isPresent()) {
            this.scan(tree.get());
        }
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.scan(tree.items());
    }

    @Override
    public void visitModule(ModuleTree tree) {
        this.scan(tree.items());
    }

    @Override
    public void visitImportDeclaration(ImportDeclarationTree tree) {
        this.scan(tree.importClause());
        this.scan(tree.fromClause());
    }

    @Override
    public void visitImportModuletDeclaration(ImportModuleDeclarationTree tree) {
        this.scan(tree.moduleName());
    }

    @Override
    public void visitImportClause(ImportClauseTree tree) {
        this.scan(tree.namedImport());
    }

    @Override
    public void visitSpecifierList(SpecifierListTree tree) {
        this.scan(tree.specifiers());
    }

    @Override
    public void visitSpecifier(SpecifierTree tree) {
        this.scan(tree.name());
        this.scan(tree.localName());
    }

    @Override
    public void visitFromClause(FromClauseTree tree) {
        this.scan(tree.module());
    }

    @Override
    public void visitDefaultExportDeclaration(DefaultExportDeclarationTree tree) {
        this.scan(tree.object());
    }

    @Override
    public void visitNameSpaceExportDeclaration(NameSpaceExportDeclarationTree tree) {
        this.scan(tree.fromClause());
    }

    @Override
    public void visitNamedExportDeclaration(NamedExportDeclarationTree tree) {
        this.scan(tree.object());
    }

    @Override
    public void visitVariableStatement(VariableStatementTree tree) {
        this.scan(tree.declaration());
    }

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        this.scan(tree.variables());
    }

    @Override
    public void visitClassDeclaration(ClassTree tree) {
        this.scan(tree.name());
        this.scan(tree.superClass());
        this.scan(tree.elements());
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }

    @Override
    public void visitParameterList(ParameterListTree tree) {
        this.scan(tree.parameters());
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }

    @Override
    public void visitBlock(BlockTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitEmptyStatement(EmptyStatementTree tree) {
    }

    @Override
    public void visitLabelledStatement(LabelledStatementTree tree) {
        this.scan(tree.label());
        this.scan(tree.statement());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statement());
        this.scan(tree.elseClause());
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.init());
        this.scan(tree.condition());
        this.scan(tree.update());
        this.scan(tree.statement());
    }

    @Override
    public void visitForInStatement(ForInStatementTree tree) {
        this.scan(tree.variableOrExpression());
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    @Override
    public void visitForOfStatement(ForOfStatementTree tree) {
        this.scan(tree.variableOrExpression());
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statement());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.scan(tree.statement());
        this.scan(tree.condition());
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        this.scan(tree.label());
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.scan(tree.label());
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitWithStatement(WithStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.statement());
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan(tree.expression());
        this.scan(tree.cases());
    }

    @Override
    public void visitDefaultClause(DefaultClauseTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitCaseClause(CaseClauseTree tree) {
        this.scan(tree.expression());
        this.scan(tree.statements());
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.block());
        this.scan(tree.catchBlock());
        this.scan(tree.finallyBlock());
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.scan(tree.parameter());
        this.scan(tree.block());
    }

    @Override
    public void visitDebugger(DebuggerStatementTree tree) {
    }

    @Override
    public void visitArrayBindingPattern(ArrayBindingPatternTree tree) {
        this.scan(tree.elements());
    }

    @Override
    public void visitObjectBindingPattern(ObjectBindingPatternTree tree) {
        this.scan(tree.elements());
    }

    @Override
    public void visitObjectLiteral(ObjectLiteralTree tree) {
        this.scan(tree.properties());
    }

    @Override
    public void visitBindingProperty(BindingPropertyTree tree) {
        this.scan(tree.name());
        this.scan(tree.value());
    }

    @Override
    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        this.scan(tree.left());
        this.scan(tree.right());
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
    }

    @Override
    public void visitArrayLiteral(ArrayLiteralTree tree) {
        this.scan(tree.elements());
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.scan(tree.variable());
        this.scan(tree.expression());
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.scan(tree.condition());
        this.scan(tree.trueExpression());
        this.scan(tree.falseExpression());
    }

    @Override
    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.scan(tree.parameters());
        this.scan(tree.conciseBody());
    }

    @Override
    public void visitYieldExpression(YieldExpressionTree tree) {
        this.scan(tree.argument());
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        this.scan(tree.leftOperand());
        this.scan(tree.rightOperand());
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitMemberExpression(MemberExpressionTree tree) {
        this.scan(tree.object());
        this.scan(tree.property());
    }

    @Override
    public void visitTaggedTemplate(TaggedTemplateTree tree) {
        this.scan(tree.callee());
        this.scan(tree.template());
    }

    @Override
    public void visitCallExpression(CallExpressionTree tree) {
        this.scan(tree.callee());
        this.scan(tree.arguments());
    }

    @Override
    public void visitTemplateLiteral(TemplateLiteralTree tree) {
        this.scan(tree.strings());
        this.scan(tree.expressions());
    }

    @Override
    public void visitTemplateExpression(TemplateExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitTemplateCharacters(TemplateCharactersTree tree) {
    }

    @Override
    public void visitParenthesisedExpression(ParenthesisedExpressionTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitComputedPropertyName(ComputedPropertyNameTree tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitPairProperty(PairPropertyTree tree) {
        this.scan(tree.key());
        this.scan(tree.value());
    }

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        this.scan(tree.expression());
        this.scan(tree.arguments());
    }

    @Override
    public void visitThisTree(ThisTree tree) {
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.scan(tree.name());
        this.scan(tree.parameters());
        this.scan(tree.body());
    }

    @Override
    public void visitRestElement(RestElementTree tree) {
        this.scan(tree.element());
    }

    @Override
    public void visitSuper(SuperTreeImpl tree) {
    }

    @Override
    public void visitExportClause(ExportClauseTree tree) {
        this.scan(tree.exports());
        this.scan(tree.fromClause());
    }
}

