/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.visitors;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.JavaScriptFileScanner;
import org.sonar.javascript.ast.visitors.AstTreeVisitorContext;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.lexical.SyntaxTrivia;

public abstract class SubscriptionAstTreeVisitor
implements JavaScriptFileScanner {
    private AstTreeVisitorContext context;
    private Collection<Tree.Kind> nodesToVisit;

    public abstract List<Tree.Kind> nodesToVisit();

    public AstTreeVisitorContext getContext() {
        return this.context;
    }

    public void visitNode(Tree tree) {
    }

    public void leaveNode(Tree tree) {
    }

    public void visitToken(SyntaxToken syntaxToken) {
    }

    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
    }

    public void visitFile(Tree scriptTree) {
    }

    @Override
    public void scanFile(AstTreeVisitorContext context) {
        this.context = context;
        this.visitFile(context.getTree());
        this.scanTree(context.getTree());
    }

    protected void scanTree(Tree tree) {
        this.nodesToVisit = this.nodesToVisit();
        this.visit(tree);
    }

    private void visit(Tree tree) {
        boolean isSubscribed = this.isSubscribed(tree);
        if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (isSubscribed) {
            this.leaveNode(tree);
        }
    }

    protected boolean isSubscribed(Tree tree) {
        return this.nodesToVisit.contains(((JavaScriptTree)tree).getKind());
    }

    private void visitChildren(Tree tree) {
        JavaScriptTree javaTree = (JavaScriptTree)tree;
        if (!javaTree.isLeaf()) {
            Iterator<Tree> iter = javaTree.childrenIterator();
            while (iter.hasNext()) {
                Tree next = iter.next();
                if (next == null) continue;
                this.visit(next);
            }
        }
    }
}

