/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class ArrowFunctionTreeImpl
extends JavaScriptTree
implements ArrowFunctionTree {
    private final Tree parameters;
    private final SyntaxToken doubleArrow;
    private Tree body;

    public ArrowFunctionTreeImpl(Tree parameters, InternalSyntaxToken doubleArrow, Tree body) {
        super(Tree.Kind.ARROW_FUNCTION);
        this.parameters = parameters;
        this.doubleArrow = doubleArrow;
        this.body = body;
        this.addChildren((AstNode)parameters, doubleArrow, (AstNode)body);
    }

    @Override
    public Tree parameters() {
        return this.parameters;
    }

    @Override
    public SyntaxToken doubleArrow() {
        return this.doubleArrow;
    }

    @Override
    public Tree conciseBody() {
        return this.body;
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.ARROW_FUNCTION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.parameters, this.body});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrowFunction(this);
    }

    public List<IdentifierTree> parameterIdentifiers() {
        if (this.parameters.is(Tree.Kind.BINDING_IDENTIFIER)) {
            return ImmutableList.of((Object)((IdentifierTree)this.parameters));
        }
        return ((ParameterListTreeImpl)this.parameters).parameterIdentifiers();
    }
}

