/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ParameterListTree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;

public class CallExpressionTreeImpl
extends JavaScriptTree
implements CallExpressionTree {
    private final ExpressionTree callee;
    private final ParameterListTree arguments;

    public CallExpressionTreeImpl(ExpressionTree callee, ParameterListTree arguments) {
        super(Tree.Kind.CALL_EXPRESSION);
        this.callee = callee;
        this.arguments = arguments;
        this.addChildren((AstNode)callee, (AstNode)arguments);
    }

    @Override
    public ExpressionTree callee() {
        return this.callee;
    }

    @Override
    public ParameterListTree arguments() {
        return this.arguments;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CALL_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.callee, this.arguments});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCallExpression(this);
    }
}

