/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.javascript.lcov.LCOVParser;

public class CoverageSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(CoverageSensor.class);
    private final FileSystem fileSystem;
    private final Settings settings;
    private final FilePredicate mainFilePredicate;

    public CoverageSensor(FileSystem fileSystem, Settings settings) {
        this.fileSystem = fileSystem;
        this.settings = settings;
        this.mainFilePredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("js"));
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fileSystem.hasFiles(this.mainFilePredicate);
    }

    public void analyse(Project project, SensorContext context) {
        if (this.isLCOVReportProvided()) {
            this.saveMeasureFromLCOVFile(context);
        } else if (this.isForceZeroCoverageActivated()) {
            this.saveZeroValueForAllFiles(context);
        }
    }

    protected void saveZeroValueForAllFiles(SensorContext context) {
        for (InputFile inputFile : this.fileSystem.inputFiles(this.mainFilePredicate)) {
            this.saveZeroValueForResource(org.sonar.api.resources.File.create((String)inputFile.relativePath()), context);
        }
    }

    protected void saveMeasureFromLCOVFile(SensorContext context) {
        String providedPath = this.settings.getString("sonar.javascript.lcov.reportPath");
        File lcovFile = CoverageSensor.getIOFile(this.fileSystem.baseDir(), providedPath);
        if (!lcovFile.isFile()) {
            LOG.warn("No coverage information will be saved because LCOV file cannot be found. Provided LCOV file path: {}", (Object)providedPath);
            LOG.warn("Provided LCOV file path: {}. Seek file with path: {}", (Object)providedPath, (Object)lcovFile.getAbsolutePath());
            return;
        }
        LOG.info("Analysing {}", (Object)lcovFile);
        LCOVParser parser = LCOVParser.create(this.fileSystem, lcovFile);
        Map<InputFile, CoverageMeasuresBuilder> coveredFiles = parser.coverageByFile();
        for (InputFile inputFile : this.fileSystem.inputFiles(this.mainFilePredicate)) {
            try {
                CoverageMeasuresBuilder fileCoverage = coveredFiles.get(inputFile);
                org.sonar.api.resources.File resource = org.sonar.api.resources.File.create((String)inputFile.relativePath());
                if (fileCoverage != null) {
                    for (Measure measure : fileCoverage.createMeasures()) {
                        context.saveMeasure((Resource)resource, measure);
                    }
                    continue;
                }
                LOG.debug("Default value of zero will be saved for file: {}", (Object)resource.getPath());
                LOG.debug("Because: either was not present in LCOV report either was not able to retrieve associated SonarQube resource");
                this.saveZeroValueForResource(resource, context);
            }
            catch (Exception e) {
                LOG.error("Problem while calculating coverage for " + inputFile.absolutePath(), (Throwable)e);
            }
        }
        List<String> unresolvedPaths = parser.unresolvedPaths();
        if (!unresolvedPaths.isEmpty()) {
            LOG.warn(String.format("Could not resolve %d file paths in %s, first unresolved path: %s", unresolvedPaths.size(), lcovFile.getName(), unresolvedPaths.get(0)));
        }
    }

    private void saveZeroValueForResource(org.sonar.api.resources.File resource, SensorContext context) {
        PropertiesBuilder lineHitsData = new PropertiesBuilder(CoreMetrics.COVERAGE_LINE_HITS_DATA);
        for (int x = 1; x < context.getMeasure((Resource)resource, CoreMetrics.LINES).getIntValue(); ++x) {
            lineHitsData.add((Object)x, (Object)0);
        }
        Measure ncloc = context.getMeasure((Resource)resource, CoreMetrics.NCLOC);
        context.saveMeasure((Resource)resource, lineHitsData.build());
        context.saveMeasure((Resource)resource, CoreMetrics.LINES_TO_COVER, ncloc.getValue());
        context.saveMeasure((Resource)resource, CoreMetrics.UNCOVERED_LINES, ncloc.getValue());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private boolean isForceZeroCoverageActivated() {
        return this.settings.getBoolean("sonar.javascript.forceZeroCoverage");
    }

    private boolean isLCOVReportProvided() {
        return StringUtils.isNotBlank((String)this.settings.getString("sonar.javascript.lcov.reportPath"));
    }

    public static File getIOFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }
}

