/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.unittest.surefireparser;

import java.text.ParseException;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.ElementFilter;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.javascript.unittest.surefireparser.UnitTestClassReport;
import org.sonar.plugins.javascript.unittest.surefireparser.UnitTestIndex;
import org.sonar.plugins.javascript.unittest.surefireparser.UnitTestResult;

public class SurefireStaxHandler
implements StaxParser.XmlStreamHandler {
    private final UnitTestIndex index;

    public SurefireStaxHandler(UnitTestIndex index) {
        this.index = index;
    }

    public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
        SMInputCursor testSuite = rootCursor.constructDescendantCursor((SMFilter)new ElementFilter("testsuite"));
        SMEvent testSuiteEvent = testSuite.getNext();
        while (testSuiteEvent != null) {
            if (testSuiteEvent.compareTo((Enum)SMEvent.START_ELEMENT) == 0) {
                String testSuiteClassName = testSuite.getAttrValue("name");
                if (StringUtils.contains((String)testSuiteClassName, (String)"$")) {
                    return;
                }
                SMInputCursor testCase = testSuite.childCursor((SMFilter)new ElementFilter("testcase"));
                SMEvent event = testCase.getNext();
                while (event != null) {
                    if (event.compareTo((Enum)SMEvent.START_ELEMENT) == 0) {
                        String testClassName = this.getClassname(testCase, testSuiteClassName);
                        UnitTestClassReport classReport = this.index.index(testClassName);
                        this.parseTestCase(testCase, classReport);
                    }
                    event = testCase.getNext();
                }
            }
            testSuiteEvent = testSuite.getNext();
        }
    }

    private String getClassname(SMInputCursor testCaseCursor, String defaultClassname) throws XMLStreamException {
        String testClassName = testCaseCursor.getAttrValue("classname");
        return StringUtils.defaultIfBlank((String)testClassName, (String)defaultClassname);
    }

    private void parseTestCase(SMInputCursor testCaseCursor, UnitTestClassReport report) throws XMLStreamException {
        report.add(this.parseTestResult(testCaseCursor));
    }

    private void setStackAndMessage(UnitTestResult result, SMInputCursor stackAndMessageCursor) throws XMLStreamException {
        result.setMessage(stackAndMessageCursor.getAttrValue("message"));
        String stack = stackAndMessageCursor.collectDescendantText();
        result.setStackTrace(stack);
    }

    private UnitTestResult parseTestResult(SMInputCursor testCaseCursor) throws XMLStreamException {
        UnitTestResult detail = new UnitTestResult();
        String name = this.getTestCaseName(testCaseCursor);
        detail.setName(name);
        String status = "ok";
        long duration = this.getTimeAttributeInMS(testCaseCursor);
        SMInputCursor childNode = testCaseCursor.descendantElementCursor();
        if (childNode.getNext() != null) {
            String elementName = childNode.getLocalName();
            if ("skipped".equals(elementName)) {
                status = "skipped";
                duration = 0L;
            } else if ("failure".equals(elementName)) {
                status = "failure";
                this.setStackAndMessage(detail, childNode);
            } else if ("error".equals(elementName)) {
                status = "error";
                this.setStackAndMessage(detail, childNode);
            }
        }
        while (childNode.getNext() != null) {
        }
        detail.setDurationMilliseconds(duration);
        detail.setStatus(status);
        return detail;
    }

    private long getTimeAttributeInMS(SMInputCursor testCaseCursor) throws XMLStreamException {
        try {
            Double time = ParsingUtils.parseNumber((String)testCaseCursor.getAttrValue("time"), (Locale)Locale.ENGLISH);
            return !Double.isNaN(time) ? (long)ParsingUtils.scaleValue((double)(time * 1000.0), (int)3) : 0L;
        }
        catch (ParseException e) {
            throw new XMLStreamException(e);
        }
    }

    private String getTestCaseName(SMInputCursor testCaseCursor) throws XMLStreamException {
        String classname = testCaseCursor.getAttrValue("classname");
        String name = testCaseCursor.getAttrValue("name");
        if (StringUtils.contains((String)classname, (String)"$")) {
            return StringUtils.substringAfter((String)classname, (String)"$") + "/" + name;
        }
        return name;
    }
}

