/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="FunctionComplexity", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionComplexityCheck
extends SquidCheck<PythonGrammar> {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;

    public void init() {
        this.subscribeTo(new AstNodeType[]{((PythonGrammar)this.getContext().getGrammar()).funcdef});
    }

    public void leaveNode(AstNode node) {
        SourceFunction function = (SourceFunction)this.getContext().peekSourceCode();
        if (function.getInt((MetricDef)PythonMetric.COMPLEXITY) > this.maximumFunctionComplexityThreshold) {
            this.getContext().createLineViolation((CodeCheck)this, "Function has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", node, new Object[]{function.getInt((MetricDef)PythonMetric.COMPLEXITY), this.maximumFunctionComplexityThreshold});
        }
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

