/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="PreIncrementDecrement", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class PreIncrementDecrementCheck
extends SquidCheck<PythonGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((PythonGrammar)this.getContext().getGrammar()).factor});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.PLUS}) && astNode.getChild(1).getFirstChild().is(new AstNodeType[]{PythonPunctuator.PLUS})) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement doesn't produce the expected result, replace use of non-existent pre-increment operator", astNode, new Object[0]);
        }
        if (astNode.getFirstChild().is(new AstNodeType[]{PythonPunctuator.MINUS}) && astNode.getChild(1).getFirstChild().is(new AstNodeType[]{PythonPunctuator.MINUS})) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement doesn't produce the expected result, replace use of non-existent pre-decrement operator", astNode, new Object[0]);
        }
    }
}

