/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S107", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class TooManyParametersCheck
extends SquidCheck<Grammar> {
    private static final int DEFAULT_MAX = 7;
    @RuleProperty(key="max", defaultValue="7")
    public int max = 7;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.LAMBDEF});
    }

    public void visitNode(AstNode node) {
        int nbParameters = node.select().children((AstNodeType)PythonGrammar.VARARGSLIST).children((AstNodeType)PythonGrammar.FPDEF).size();
        if (nbParameters > this.max) {
            String name = "Lambda";
            if (node.is(new AstNodeType[]{PythonGrammar.FUNCDEF})) {
                String typeName = CheckUtils.isMethodDefinition(node) ? "Method" : "Function";
                name = node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getTokenOriginalValue();
                name = String.format("%s \"%s\"", typeName, name);
            }
            String message = "{0} has {1} parameters, which is greater than the {2} authorized.";
            this.getContext().createLineViolation((CodeCheck)this, message, node.getFirstChild(new AstNodeType[]{PythonGrammar.VARARGSLIST}), new Object[]{name, nbParameters, this.max});
        }
    }
}

