/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1313", priority=Priority.MAJOR, name="IP addresses should not be hardcoded", tags={"cert", "security"})
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="30min")
@ActivatedByDefault
public class HardcodedIPCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1313";
    private static final String IP_ADDRESS_REGEX = "((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))";
    private static final Pattern pattern = Pattern.compile("((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))");
    String message = "Make this IP \"%s\" address configurable.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.STRING});
    }

    public void visitNode(AstNode node) {
        String string = node.getTokenOriginalValue();
        if (this.isMultilineString(string)) {
            return;
        }
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String ipAddress = matcher.group();
            this.getContext().createLineViolation((CodeCheck)this, String.format(this.message, ipAddress), node, new Object[0]);
        }
    }

    private boolean isMultilineString(String string) {
        return string.endsWith("'''") || string.endsWith("\"\"\"");
    }
}

