/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.List;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;

public class CheckUtils {
    private CheckUtils() {
    }

    public static boolean isMethodDefinition(AstNode node) {
        AstNode parent = node.getParent();
        for (int i = 0; i < 3; ++i) {
            if (parent == null) continue;
            parent = parent.getParent();
        }
        return parent != null && parent.is(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public static boolean equalNodes(AstNode node1, AstNode node2) {
        if (!node1.getType().equals(node2.getType()) || node1.getNumberOfChildren() != node2.getNumberOfChildren()) {
            return false;
        }
        if (node1.getNumberOfChildren() == 0) {
            return node1.is(new AstNodeType[]{PythonTokenType.INDENT, PythonTokenType.DEDENT}) || node1.getToken().getValue().equals(node2.getToken().getValue());
        }
        List children1 = node1.getChildren();
        List children2 = node2.getChildren();
        for (int i = 0; i < children1.size(); ++i) {
            if (CheckUtils.equalNodes((AstNode)children1.get(i), (AstNode)children2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean insideFunction(AstNode astNode, AstNode funcDef) {
        return astNode.getFirstAncestor((AstNodeType)PythonGrammar.FUNCDEF).equals(funcDef);
    }

    public static boolean classHasNoInheritance(AstNode classDef) {
        AstNode inheritanceClause = classDef.getFirstChild(new AstNodeType[]{PythonGrammar.ARGLIST});
        if (inheritanceClause == null) {
            return true;
        }
        AstNode argument = inheritanceClause.getFirstChild(new AstNodeType[]{PythonGrammar.ARGUMENT});
        return argument != null && "object".equals(argument.getTokenValue());
    }

    public static boolean isAssignmentExpression(AstNode expression) {
        int numberOfChildren = expression.getNumberOfChildren();
        int numberOfAssign = expression.getChildren(new AstNodeType[]{PythonPunctuator.ASSIGN}).size();
        if (numberOfChildren == 3 && numberOfAssign == 1) {
            return true;
        }
        return numberOfAssign > 0 && numberOfChildren % 2 != 0 && numberOfAssign * 2 + 1 == numberOfChildren;
    }

    public static boolean containsValue(List<Token> list, String value) {
        for (Token currentToken : list) {
            if (!currentToken.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }
}

