/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S101", priority=Priority.MINOR, name="Class names should comply with a naming convention", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class ClassNameCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S101";
    private static final String DEFAULT = "^[A-Z_][a-zA-Z0-9]+$";
    @RuleProperty(key="format", defaultValue="^[A-Z_][a-zA-Z0-9]+$")
    public String format = "^[A-Z_][a-zA-Z0-9]+$";
    private Pattern pattern = null;

    public void init() {
        this.pattern = Pattern.compile(this.format);
        this.subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF});
    }

    public void visitNode(AstNode astNode) {
        String className = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}).getTokenValue();
        if (!this.pattern.matcher(className).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename class \"{0}\" to match the regular expression {1}.", astNode, new Object[]{className, this.format});
        }
    }
}

