/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1066", priority=Priority.MAJOR, name="Collapsible \"if\" statements should be merged", tags={"clumsy"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class CollapsibleIfStatementsCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1066";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.IF_STMT});
    }

    public void visitNode(AstNode node) {
        AstNode suite = node.getLastChild(new AstNodeType[]{PythonGrammar.SUITE});
        if (suite.getPreviousSibling().getPreviousSibling().is(new AstNodeType[]{PythonKeyword.ELSE})) {
            return;
        }
        AstNode singleIfChild = this.singleIfChild(suite);
        if (singleIfChild != null && !this.hasElseOrElif(singleIfChild)) {
            this.getContext().createLineViolation((CodeCheck)this, "Merge this if statement with the enclosing one.", singleIfChild, new Object[0]);
        }
    }

    private boolean hasElseOrElif(AstNode ifNode) {
        return ifNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.ELIF}) || ifNode.hasDirectChildren(new AstNodeType[]{PythonKeyword.ELSE});
    }

    private AstNode singleIfChild(AstNode suite) {
        AstSelect nestedIf;
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1 && (nestedIf = ((AstNode)statements.get(0)).select().children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.IF_STMT)).size() == 1) {
            return nestedIf.get(0);
        }
        return null;
    }
}

